
/*
serial.c copyright (c) 2005 Jan Panteltje

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "lremote.h"


#define COM1BASE    0x3f8
#define COM2BASE    0x2f8
#define COM3BASE    0x3e8
#define COM4BASE    0x2e8


int get_combase(char *serial_device, int *combase)
{
if(debug_flag)
	{
	// this will scroll of screen, as it is called checking for reset

/*
	fprintf(stderr,\
	"get_combase(): arg serial device=%s\n", serial_device);
*/
	}

if(strcmp(serial_device, "/dev/cua0") == 0) *combase = COM1BASE;
else if(strcmp(serial_device, "/dev/cua1") == 0) *combase = COM2BASE;
else if(strcmp(serial_device, "/dev/cua2") == 0) *combase = COM3BASE;
else if(strcmp(serial_device, "/dev/cua3") == 0) *combase = COM4BASE;
/*
Added ttySx because of this in /var/log/messages:
tty_io.c: process 1104 (viemu) used obsolete /dev/cua1-
update software to use /dev/ttyS1
*/
else if(strcmp(serial_device, "/dev/ttyS0") == 0) *combase = COM1BASE;
else if(strcmp(serial_device, "/dev/ttyS1") == 0) *combase = COM2BASE;
else if(strcmp(serial_device, "/dev/ttyS2") == 0) *combase = COM3BASE;
else if(strcmp(serial_device, "/dev/ttyS3") == 0) *combase = COM4BASE;
else 
	{
	printf("Invalid serial device %s\n", serial_device);

	return 0;
	}

return 1;
} /* end function get_combase */


int set_rts(char *device, int state)
/* sets RTS to on or off */
{
int a;
int combase;

if(debug_flag)
	{
	fprintf(stderr, "set_rts(): device=%s state=%d\n",\
	device, state);
	}

#define RTS 1

if(! get_combase(device, &combase) )
	{
	return 0;
	}

a = inb(combase + 4);

// /* bit is inverted */

if(state == 1) a |= (1 << RTS); /* set bit 1 (RTS) */
else a &= ~(1 << RTS); /* reset bit 1 (RTS) */

outb(a, combase + 4);

return 1;
} /* end function set_rts */




int serial_send(char *command) /* send a command via the seria lport RTS line */
{
/*
If the 486 has more then 16 Mb ram, the L1 (internal) cache can only
cache 16 Mb.
L2 cache is too slow if any wait states.
The stack would be high in memory and possibly not cached.
This would run to slow.
Using a static just seems to solve this (no guarantee).
(I upgraded from 12 Mb to 24 Mb, and every thing slowed down !)
*/
static char irdata[IR_DATA_LENGTH];
unsigned char one, zero;
long li;
char command_file[40];
FILE *ircmdfile;
int a, b, c;
int i;
int combase;

//int get_combase(char *serial_device, int *combase)
if(! get_combase(serial_device_name, &combase) )
	{
	fprintf(stderr, "lremote: serial_send(): could not get combase, aborting.\n");

	exit(1);
	}

//get_path_name("ir_remote_command_files_dir", path);
sprintf(command_file, "%s%s.irc", "/root/.lremote/commands/", command);
ircmdfile = fopen(command_file, "rb");
if(!ircmdfile)
	{
	printf("\nCannot open remote command file %s\n", command_file);

	return 0;
	}	
/* load file bytes and expand in bit array */
li = 0;
while(1)
	{
	c = getc(ircmdfile);
	if(c == EOF) break;
	for(i = 0; i < 8; i ++)
		{
		irdata[li] = c & 128; /* get bit 7, also note: c is an integer */

		c <<= 1; /* shift left one position */

		li++;
		if(li == IR_DATA_LENGTH) break;
		}
	if(li >= IR_DATA_LENGTH) break; /* array boundary */
	}
fclose(ircmdfile);

/* do out of the loop what is possible */

//one = data_read | 4; /* set bit 2 */
//zero = data_read & 251;

a = inb(combase + 4);
one =   a |= (1 << RTS); /* set bit 1 (RTS) */
zero = a &= ~(1 << RTS); /* reset bit 1 (RTS) */

b = combase + 4;

for(li = 0; li < IR_DATA_LENGTH; li++)
	{
	if(irdata[li]) outb(one, b);
	else outb(zero, b);

//  any delay makes it fail, even on a k6-450, the ISA bus delay counts!
//	microseconds_wait(1);
	}

/* stop condition, so iic bus can be used */

/* leave transmitter off */
outb(zero, b);	/* bit is inverted */

return 1;
}



int set_rts_off()
{
int a;
int combase;

//int get_combase(char *serial_device, int *combase)
if(! get_combase(serial_device_name, &combase) )
	{
	fprintf(stderr, "lremote: set_rts_off(): could not get combase, aborting.\n");

	exit(1);
	}

a = inb(combase + 4);
a &= ~(1 << RTS); /* reset bit 1 (RTS) */
outb(a, combase + 4);

return 1;
}



