/*
This program is free software; you can redistribute it and/or modify
it under the ; (at your option) any later version.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Copyright Jan panteltje 2009-always 

read and write routines to grab data from a 433.X MHz receiver, and send data to a 433.X MHz transmitter
*/

#include "lremote.h"


/*
i/o used:		parallel printer port for iic bus interface

scl				bit 7 0x378 =pin 9		(d7)				
sda pull down	bit 6 0x378 =pin 8		(d6)	 via si diode, anode on p15
sdain			bit 3 0x379 =pin 15		(ERROR)

tx				bit 2 0x378 =pin 4 		(d2)
*/



void busdly(d)
int d;
{
int i;

for(i = 0; i < d; i++)
	{
	d = d;
	}
}


void sclh()
{
int register a;

a = inb(par_port_address);
a = a | 128;/*set bit 7 (d7 on pin 9)*/
outb(a, par_port_address);
busdly(IIC_BUS_DELAY);
}


void sdah()
{
register char a;

a = inb(par_port_address);
a = a | 0x40;/*set bit 6 (d6 on pin 8)*/
outb(a, par_port_address);
busdly(IIC_BUS_DELAY);
}


void ir_off()
{
register char data_read;

/* leave transmitter off */
data_read = inb(par_port_address);
//data_read |= 4; /* set bit 2 */
data_read &= 251; /* reset bit 2 */
outb(data_read, par_port_address);
}


int ir_remote_send(char command[])/*send a remote commnd*/
{
/*
If the 486 has more then 16 Mb ram, the L1 (internal) cache can only
cache 16 Mb.
L2 cache is to slow if any wait states.
The stack would be high in memory and possibly not cached.
This would run to slow.
Using a static just seems to solve this (no guarantee).
(I upgraded from 12 Mb to 24 Mb, and every thing slowed down !)
*/
static char irdata[IR_DATA_LENGTH];
register char data_read;
unsigned char one, zero;
long li;
char command_file[40];
FILE *ircmdfile;
int c;
int i;

//get_path_name("ir_remote_command_files_dir", path);
sprintf(command_file, "%s%s.irc", "/root/.lremote/commands/", command);
ircmdfile = fopen(command_file, "rb");
if(!ircmdfile)
	{
	printf("\nCannot open remote command file %s\n", command_file);
	return 0;
	}	
/* load file bytes and expand in bit array */
li = 0;
while(1)
	{
	c = getc(ircmdfile);
	if(c == EOF) break;
	for(i = 0; i < 8; i ++)
		{
		irdata[li] = c & 128; /* get bit 7, also note: c is an integer */

		c <<= 1; /* shift left one position */

		li++;
		if(li == IR_DATA_LENGTH) break;
		}
	if(li >= IR_DATA_LENGTH) break; /* array boundary */
	}
fclose(ircmdfile);

/* do out of the loop what is possible */
data_read = inb(par_port_address);
//one = data_read | 128;
//zero = data_read & 127;

one = data_read | 4; /* set bit 2 */
zero = data_read & 251;

for(li = 0; li < IR_DATA_LENGTH; li++)
	{
	if(irdata[li]) outb(one, par_port_address);
	else outb(zero, par_port_address);

//  any delay makes it fail, even on a k6-450, the ISA bus delay counts!
//	microseconds_wait(1);
	}

/* stop condition, so iic bus can be used */
sdah();
sclh();

/* leave transmitter off */
data_read = inb(par_port_address);
//data_read |= 4; /* set bit 2 */
data_read &= 251; /* reset bit 2 */
outb(data_read, par_port_address);

return 1;
}


int ir_remote_learn()/*learn a remote command*/
{
char irdata[IR_DATA_LENGTH];
register int a;
long li,ld;
FILE *ircmdfile;
char c;
char str[20];
char command_name[20];
char command_file[40];
unsigned char combined;
int i;

printf("\nPress ESC key to start reading data.\n");

ld = 0;/*used as delay only, compiler removes constructions like a = a repeated many times*/

system("stty raw");
while(1)
	{
	a = getchar();

	if(a == 27) break;
	}
system("stty sane");

for(li = 0; li < IR_DATA_LENGTH; li++)
	{
	a = inb(par_port_address + 1) & 8;/*bit 3 only*/
	ld++;/*for timing to get same timing as send loop*/
	ld--;
	ld++;
	irdata[li] = a;
	}

printf("\nIR data has been read, press ESC key save to file.\n");

system("stty raw");
while(1)
	{
	a = getchar();

	if(a == 27) break;
	}
system("stty sane");

/*now going to save in file*/
while(1)/*ask for command name*/
	{
	printf("\nCommand file name? ");
	fscanf(stdin, "%8s", command_name);
	printf("\n");
//	get_path_name("ir_remote_command_files_dir", path);

	sprintf(command_file, "%s%s.irc", "/root/.lremote/commands/", command_name);
	ircmdfile = fopen(command_file, "r");
	if(ircmdfile)
		{
		fclose(ircmdfile);
		printf("\nCommand file %s already exists, overwrite (y/n)? \n",\
		command_file);
		fscanf(stdin,"%1s", str);
		toupper(str[0]);
		if(str[0] == 'Y')break;/*from while asking command name*/
		printf("\nCancel data read (y/n)? ");
		fscanf(stdin, "%1s", str);
		toupper(str[0]);
		if(str[0] == 'N')return 0;/*error, loose data*/
		}
	else break;/*create*/
	}/*end while ask for command name*/

ircmdfile = fopen(command_file, "wb");
if(!ircmdfile)
	{
	printf("\nCannot open command file %s for write\n", command_name);
	return 0;/*error*/
	}

printf("\nsaving data");
li = 0;
while(1)
	{
	if(li >= IR_DATA_LENGTH)break;/*array boundary*/
	combined = 0;/*reset combined bits to 0*/
	for(i = 0; i < 8; i++)
		{
		c = irdata[li];/*get a bit*/
		li++;/*point to next element in array*/
		if(li == IR_DATA_LENGTH)break;
		combined <<= 1;/*shift left byte one position*/
		/*note << sets bit 0 to zero*/
		if(c)combined |= 1;/*set bit 0*/
		}/*end for each 8 bits*/
	putc(combined, ircmdfile);/*write a byte*/
	}/*end while all data in irdata array*/
fclose(ircmdfile);
printf("\nReady\n");
return 1;
}


