
/*
e2s (c) 2009-always Jan Panteltje

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/



#include "e2s.h"


char *strsave(char *s) /* save char array s somewhere */
{
char *p;

p = malloc(strlen(s) +  1);
if(p) strcpy(p, s);

return p;
} /* end function strsave */



void print_usage()
{
fprintf(stderr,
"\nPanteltje e2s-%s\n\
Usage:\ne2s [-b baudrate] [-d serial_device_name] [-h] [-p port] [-u] [-v]\n\
-b baudrate                 baudrate, either 75, 150, 300, 600, 1200, 2400, 4800, 9600, 19200, 38400, 57600, or 115200, default %d.\n\
-d serial_device_name       serial device name, default %s.\n\
-h                          help (this help.\n\
-p port                     internet port in decimal, default %d.\n\
-u                          use universal time when reporting connects.\n\
-v                          debug, prints variables, functions and arguments.\n\
\n",\
PROG_VERSION, DEFAULT_BAUDRATE, DEFAULT_SERIAL_DEVICE_NAME, DEFAULT_PORT);
fprintf(stderr, "Example that creates a server for /dev/ttyUSB1 with 19200 Baud listening on port 8192:\n\
 e2s -d /dev/ttyUSB1 -b 19200 -p 8192\n"\
 );

} /* end function print_usage */


#ifndef LINKSYS_WAP_MIPS
int set_port_parameters(int fd, int baudrate)
{
struct termios tty;
speed_t baud;

if(debug_flag)
	{
	fprintf(stderr, "e2s: set_port_parameters(): arg fd=%d baudrate=%d\n", fd, baudrate);
	}

/* convert real baudrates to 'B' baudrates */
switch(baudrate)
	{
	case 75:
		baud = B75;
		break;
	case 150:
		baud = B150;
		break;
	case 300:
		baud = B300;
		break;
	case 600:
		baud = B600;
		break;	
	case 1200:
		baud = B1200;
		break;
	case 2400:
		baud = B2400;
		break;
	case 4800:
		baud = B4800;
		break;	
	case 9600:
		baud = B9600;
		break;
	case 19200:
		baud = B19200;
		break;
	case 38400:
		baud = B38400;
		break;
	case 57600:
		baud = B57600;
		break;
	case 115200:
		baud = B115200;
		break;
	default:
		fprintf(stderr, "e2s: baudrate=%d unsupported\n", baudrate);
		return 0;
		break;
	} /* end switch baudrate */

/* set comport parameters */
tcgetattr(fd, &tty);

tty.c_cflag = 0;
tty.c_cflag |= CLOCAL;			/* ignore modem control lines */
tty.c_cflag |= CREAD;			/* enable receiver */
tty.c_cflag |= CS8;				/* use 8 data bits */
//tty.c_cflag |= CSTOPB;		/* 2 stop bits */
//tty.c_cflag |= PARENB;		/* enable parity */
//tty.c_cflag |= PARODD;		/* use odd parity */
//tty.c_cflag &= ~CRTSCTS;		/* do not use RTS and CTS handshake */

tty.c_iflag = 0;
tty.c_iflag |= IGNBRK;
tty.c_iflag |= IGNPAR;
//tty.c_iflag |= PARMRK
//tty.c_iflag |= INPCK;
//tty.c_iflag |= INLCR;
//tty.c_iflag |= ISTRIP
//tty.c_iflag &= ~(IXON | IXOFF | IXANY);

tty.c_oflag = 0;

tty.c_lflag = 0;
//tty.c_lflag |= ICANON;
//tty.c_cc[VMIN] = 1;
//tty.c_cc[VTIME] = 5;
//tty.c_lflag &= ~(ECHO|ECHONL|ICANON|ISIG|IEXTEN);


cfsetospeed(&tty, (speed_t)baud);
cfsetispeed(&tty, (speed_t)baud);

tcsetattr(fd, TCSANOW, &tty);

return 1;
} /* end function set_port_parameters */

#endif // LINKSYS_WAP_MIPS


int main(int argc, char **argv)
{
int a;
int serial_fd;
char temp[INTERNET_BUFFER_SIZE];

get_time(temp);

/* defaults */
internet_port = DEFAULT_PORT;

baudrate = DEFAULT_BAUDRATE;
serial_device_name = strsave(DEFAULT_SERIAL_DEVICE_NAME);
if(! serial_device_name)
	{
	fprintf(stderr, "e2s: %s could not allocate space for serial_device_name, aborting.\n", temp);
	exit(1);
	}

use_universal_time_flag = 0;
debug_flag = 0;
/* end defaults */

while(1)
	{
	a = getopt(argc, argv, "a:b:d:hi:p:uv");
	if(a == -1) break;

	switch(a)
		{
		case 'b':
			baudrate = atoi(optarg);
			break;		
		case 'd':
			free(serial_device_name);
			serial_device_name = strsave(optarg);
			if(! serial_device_name)
				{
				fprintf(stderr, "e2s: %s could not allocate space for serial_device_name, aborting.\n", temp);
				exit(1);
				}
			break;
		case 'h':
			print_usage();
			exit(1);
			break;
		case 'p':
			internet_port = atoi(optarg);
			break;
		case 'u':
			use_universal_time_flag = 1;
			break;
		case 'v':
			debug_flag = 1;
			break;
        case -1:
        	break;
		case '?':
			if (isprint(optopt) )
 				{
 				fprintf(stderr, "e2s: %s unknown option `-%c'.\n", temp, optopt);
 				}
			else
				{
				fprintf(stderr, "e2s: %s unknown option character `\\x%x'.\n", temp, optopt);
				}
			print_usage();

			exit(1);
			break;			
		default:
			print_usage();

			exit(1);
			break;
		}/* end switch a */
	}/* end while getopt() */


serial_fd = open(serial_device_name, O_RDWR);
if(serial_fd  == -1)
	{
	fprintf(stderr, "e2s: %s could not open serial device %s for read write, aborting.\n", temp, serial_device_name);
	
	exit(1);
	}

#ifndef LINKSYS_WAP_MIPS
//int set_port_parameters(int fd, baudrate)
if(! set_port_parameters(serial_fd, baudrate) )
	{
	fprintf(stderr, "Try  e2s -h  for help on baudrates.\n");
	fprintf(stderr, "e2s: %s aborting.\n", temp);

	exit(1);
	}
#endif // LINKSYS_WAP_MIPS


if(! internet_routine(serial_fd) )
	{
	fprintf(stderr, "e2s: %s aborting.\n", temp);

	exit(1);
	}

exit(0);
} /* end function main */


