/*
 *   Copyright 1995 Peter Scott  (OZ2ABA/OZ7SAT)
 *              All Rights Reserved
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
	filerequest.c

	Request a file from the satellite. Controls the pb program
*/

#define VERSION_STRING "(version 1.0 by oz2aba)"

#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <ctype.h>
#include <time.h>
#include <strings.h>

#include "pb.h"

char	Id [100];

/* Download files control structures */
unsigned long download_list [MAXDOWNLOAD];

unsigned long fileId;

int main(int argc, char **argv)
{
	FILE	*fp;
	long	l;
	int		x;

	if (argc != 2) {
		printf ("Usage: %s fileId\n", argv[0]);
		exit (1);
	}
	strcpy (Id, argv [1]);
	sscanf(Id, "%lx", &fileId);

	/* Read the download.req file */

	fp = fopen ("download.req", "r+");
	if (fp == NULL) {		/* No download file. Abort */
		printf ("download.req control file does not exist\n");
		exit (1);
	}

	fread (download_list, sizeof (unsigned long), MAXDOWNLOAD, fp);
	if (ferror (fp)) {			/* Error reading. Abort */
		printf ("Error reading download.req\n");
		exit (1);
	}

	/* Check if the requested file exist in the list */
	for (x = 0; x < MAXDOWNLOAD; x++) {
		if (download_list [x] == fileId) {
			/* The file is allready in the list */
			printf ("The file %lx has already been requested\n",
			        fileId);
			fclose (fp);
			exit (0);
		}
	}

	/* The request does not exist. Find a empty slot */
	for (x = 0; x < MAXDOWNLOAD; x++) {
		if (download_list [x] == 0xFFFFFFFF) break;
	}
	if (download_list [x] != 0xFFFFFFFF) {
		printf ("Not space for more requests\n");
		fclose (fp);
		exit (10);
	}

	/* Set the entry in the list and the file */
	download_list [x] = fileId;
	l = sizeof (unsigned long) * x;
	fseek (fp, l, SEEK_SET);
	fwrite (&download_list [x], sizeof (unsigned long), 1, fp);
	if (ferror (fp)) {		/* Error writing to file */
		printf ("Error writing to download.req file\n");
		fclose (fp);
		exit (1);
	}
	fclose (fp);

	/* Notify the user */
	printf ("File %lx requested\n", fileId);

	return (0);		/* Return OK */
}
