/*
 * twcw:  A gui application that sends Morse Code 
 * Copyright (C) 1997 Ted Williams WA0EIR 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
 * Version: 1.4  JAN 2008
 */

/*
 *  build_widgets Function
 *  Create all of the widgets for the main interface
 */
#include "common.h"
#include "twcw.h"
#define  SPACING 10

void build_widgets (Widget shell, AppRes *resptr, int mode)
{
   // TJW 2.0 Widget scale2, scale3, scale4;
   // TJW Widget pb1;
   Widget form1;
   Widget callLabel, menuBar, form2, form3;       /* form1 kids */

   Widget fileCas, controlsCas, helpCas;          /* menuBar kids */
   Widget fileMenu, controlsMenu, helpMenu;
   Widget sep, *fileBtns=0;                       /* for file menu */
   Widget sendBtn, rcvdBtn, resetBtn;             /* for controls menu */
   Widget rxBtn, txBtn;                           /* more controls menu */
   Widget aboutBtn, helpBtn;                      /* for help menu */

   Widget pane1;                                  /* form3 kids */

   Widget form4;
   Widget txFrame, txRC;

   Widget form5;
   Widget trFrame, trRC, keyRC;
   Widget popup;
   /* labels for Scale label fix */
   /* wpm and tone here - farns is in globals */
   Widget wpmLabel, toneLabel; 
   // TJW 2.0 Widget label4, label5, label6, label7;

   char file_acc_text[10];
   char file_acc_num[2];
   char file_acc_key[12];
   int i=0, cnt;
   XmString xs;
   XmString clr_send_xs, clr_rcvd_xs, reset_xs, quit_xs;
   XmString clr_rcvd_acc_xs, clr_send_acc_xs, reset_acc_xs, quit_acc_xs;
   Arg args[20];
   XtActionsRec actions[] =
      {
         {"sendOver", sendOver},
         {"sendHisCall", sendHisCall},
         {"sendMacro", sendMacro},
         {"sendPro", sendPro}
      };

   /*
    * form1 - main form
    */
   form1 = XtVaCreateWidget ("form1", xmFormWidgetClass, shell,
      NULL);
	   
   /*
    * callLabel - callsign label
    */
   callLabel = XtVaCreateManagedWidget ("callLabel", xmLabelWidgetClass, form1,
      XmNtopAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_NONE,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);

   /*
    * menu - Make the main menu bar and its cascades.
    */

   menuBar = XmCreateMenuBar (form1, "menuBar", NULL, 0);
   XtVaSetValues (menuBar,
      XmNleftOffset, SPACING,
      XmNrightOffset, SPACING,
      NULL);

   fileMenu = XmCreatePulldownMenu (menuBar, "filePullDown", NULL, 0);
   XtVaSetValues (fileMenu,
      XmNtearOffModel, XmTEAR_OFF_ENABLED,
      NULL);

   xs = XmStringCreateLocalized ("File");
   fileCas = XtVaCreateManagedWidget ("File", xmCascadeButtonWidgetClass,
      menuBar,
      XmNlabelString, xs,
      XmNmnemonic, 'F',
      XmNsubMenuId, fileMenu,
      NULL);
   XmStringFree (xs);

   /*
    * Count the buttons names for the File pulldown
    * and malloc space for them plus the QRT button.
    * A maximum of 9 buttons are allowed not counting
    * the QRT button.
    */
   cnt=0;
   while (resptr->buttonNames[cnt] != NULL)
      cnt++;

   if (cnt > 9)                                        /* Too many files */
   {
      /*
       * On this error, realize the shell so we get application modal.
       * The shell will not be displayed, because we have not entered 
       * the event loop - but that's OK
       */
      XtRealizeWidget (shell);
      errorDiag (shell, "There are more than 9 file names \n"
                        "in your Twcw resource file.  Pls fix.",
                        NO_CANCEL);
   }

   fileBtns = (Widget *)XtMalloc (sizeof(Widget *) * (cnt+2)); 

   /*
    * Create the buttons for the File pulldown
    */
   for (i=0; i<cnt; i++)                               /* file namebuttons */
   {
      strcpy (file_acc_text, "Ctrl-");
      sprintf(file_acc_num, "%d", i+1);            
      strcat (file_acc_text, file_acc_num);
      xs = XmStringCreateLocalized (file_acc_text);    /* for accelerator */
      
      strcpy (file_acc_key, "Ctrl<Key>");
      strcat (file_acc_key, file_acc_num);             /* for accelerator */

      fileBtns[i] = XtVaCreateManagedWidget(resptr->buttonNames[i],
         xmPushButtonWidgetClass, fileMenu,
         XmNacceleratorText, xs,
         XmNaccelerator, file_acc_key,
         XmNuserData, (XtPointer) resptr,
         NULL);

      XmStringFree (xs);
   }

   sep = XtVaCreateManagedWidget ("sep", xmSeparatorWidgetClass,
      fileMenu,
      NULL);
                                                   /* Add QRT button */   
   xs = XmStringCreateLocalized ("Ctrl-Q");
   fileBtns[i] = XtVaCreateManagedWidget("QRT", xmPushButtonWidgetClass,
      fileMenu,
      XmNaccelerator, "Ctrl<Key>Q",
      XmNacceleratorText, xs,
      XmNmnemonic, 'Q',
      XmNmnemonicCharSet, XmFONTLIST_DEFAULT_TAG,
      NULL);
      XmStringFree (xs);

   /*
    * Create the Edit Button and pulldown
    */
   controlsMenu = XmCreatePulldownMenu (menuBar, "controlsPullDown", NULL, 0);

   XtVaSetValues (controlsMenu,
      XmNtearOffModel, XmTEAR_OFF_ENABLED,
      NULL);

   xs = XmStringCreateLocalized ("Controls");
   controlsCas = XtVaCreateManagedWidget("Controls", xmCascadeButtonWidgetClass,
      menuBar,
      XmNlabelString, xs,
      XmNmnemonic, 'C',
      XmNsubMenuId, controlsMenu,
      NULL);
   XmStringFree (xs);

   xs = XmStringCreateLocalized ("Ctrl-C");
   rcvdBtn = XtVaCreateManagedWidget("Clear Copy", xmPushButtonWidgetClass,
      controlsMenu,
      XmNaccelerator, "Ctrl<Key>C",
      XmNmnemonic, 'C',
      XmNacceleratorText, xs,
      NULL);
   XmStringFree (xs);

   /*
    * but if CWIRC mode, we don't want menu "Clear Copy" button one
    */
   if (mode == CWIRC)
   {
      XtVaSetValues (rcvdBtn,
         XmNsensitive, False,
         NULL);
   }

   xs = XmStringCreateLocalized ("Ctrl-S");
   sendBtn = XtVaCreateManagedWidget("Clear Send", xmPushButtonWidgetClass,
      controlsMenu,
      XmNaccelerator, "Ctrl<Key>S",
      XmNmnemonic, 'S',
      XmNacceleratorText, xs,
      NULL);
   XmStringFree (xs);

   xs = XmStringCreateLocalized ("Ctrl-A");
   resetBtn = XtVaCreateManagedWidget("Clear All", xmPushButtonWidgetClass,
      controlsMenu,
      XmNaccelerator, "Ctrl<Key>A",
      XmNmnemonic, 'A',
      XmNacceleratorText, xs,
      NULL);
   XmStringFree (xs);
   sep = XtVaCreateManagedWidget ("sep", xmSeparatorWidgetClass,
      controlsMenu,
      NULL);

   xs = XmStringCreateLocalized ("Ctrl-P");
   practiceTB = XtVaCreateManagedWidget ("Practice", xmToggleButtonWidgetClass,
      controlsMenu,
      XmNvisibleWhenOff, True,
      XmNaccelerator, "Ctrl<Key>P",
      XmNmnemonic, 'P',
      XmNacceleratorText, xs,
      XmNset, False,
      NULL);
   XmStringFree (xs);

   sep = XtVaCreateManagedWidget ("sep", xmSeparatorWidgetClass,
      controlsMenu,
      NULL);

   xs = XmStringCreateLocalized ("Ctrl-R");
   rxBtn = XtVaCreateManagedWidget("Recv", xmPushButtonWidgetClass,
      controlsMenu,
      XmNmnemonic, 'R',
      XmNaccelerator, "Ctrl<Key>R",
      XmNacceleratorText, xs,
      NULL);
   XmStringFree (xs);

   xs = XmStringCreateLocalized ("Ctrl-X");
   txBtn = XtVaCreateManagedWidget("Xmit", xmPushButtonWidgetClass,
      controlsMenu,
      XmNmnemonic, 'X',
      XmNaccelerator, "Ctrl<Key>X",
      XmNacceleratorText, xs,
      NULL);
   XmStringFree (xs);

   /*
    * Create the Help Button and pulldown
    */
   helpMenu = XmCreatePulldownMenu (menuBar, "helpPullDown", NULL, 0);

   xs = XmStringCreateLocalized ("Help");
   helpCas = XtVaCreateManagedWidget ("Help", xmCascadeButtonWidgetClass,
      menuBar,
      XmNlabelString, xs,
      XmNmnemonic, 'H',
      XmNsubMenuId, helpMenu,
      NULL);
   XmStringFree (xs);
     
   aboutBtn = XtVaCreateManagedWidget("About",
      xmPushButtonWidgetClass, helpMenu, NULL);
   
   helpBtn = XtVaCreateManagedWidget("Help", xmPushButtonWidgetClass, helpMenu,
      XmNuserData, (XtPointer) resptr,
      NULL);

   XtVaSetValues (menuBar,
      XmNtopAttachment, XmATTACH_WIDGET,
      XmNtopWidget, callLabel,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      XmNmenuHelpWidget, helpCas,
      NULL);
      
/*
 * End of Menu Stuff
 */

   /*
    * form 2 - form for all of the bottom widgets
    */
   form2 = XtVaCreateWidget ("form2", xmFormWidgetClass, form1,
      XmNhorizontalSpacing, SPACING,
      //XmNverticalSpacing, SPACING,
      XmNtopAttachment, XmATTACH_NONE,
      XmNleftAttachment, XmATTACH_FORM,       
      XmNbottomAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      XmNhorizontalSpacing, SPACING,
      XmNverticalSpacing, SPACING,
      NULL);

   /*
    * form4 - for transmit control widgets
    * WPM, Tone, and Farnsworth
    */
   form4 = XtVaCreateWidget ("form4", xmFormWidgetClass, form2,
      XmNtopAttachment, XmATTACH_NONE,
      XmNleftAttachment, XmATTACH_FORM,       
      XmNbottomAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_NONE,
      NULL);
   
   /*
    * txFrame - frame for txRC with wpm, tone and farnsworth
    */
   txFrame = XtVaCreateManagedWidget ("txFrame", xmFrameWidgetClass, form4,
      XmNtopAttachment, XmATTACH_NONE,
      XmNleftAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_NONE,
      XmNshadowType, XmSHADOW_OUT,
      XmNshadowThickness, 3,
      NULL);

   /*
    * txRC - row column for transmit controls - 
    * WPM, Tone, and Farnsworth scales
    */
   txRC = XtVaCreateWidget ("txRC", xmRowColumnWidgetClass, txFrame,
      XmNorientation, XmVERTICAL,     
      //XmNpacking, XmPACK_TIGHT,
      XmNtopAttachment, XmATTACH_NONE,
      XmNleftAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_NONE,
      NULL);

   #ifdef SCALE_BUG
   wpmLabel = XtVaCreateManagedWidget ("WPM", xmLabelWidgetClass, txRC,
      XmNalignment, XmALIGNMENT_CENTER,
      NULL);
   #endif

   /*
    * wpmScale - scale for WPM
    */
   wpmScale = XtVaCreateManagedWidget ("wpmScale", xmScaleWidgetClass, txRC,
      XmNorientation, XmHORIZONTAL,
      XmNminimum, MIN_WPM,
      XmNmaximum, MAX_WPM,
      #ifndef SCALE_BUG
      XmNtitleString, XmStringCreateLocalized ("WPM"),
      #endif
      XmNshowValue, True,
      XmNscaleMultiple, 1,
      NULL);

   /*
    * SCALE_BUG will create labels above Scales as a work
    * around for the SCALE label gadget problem
    */
   #ifdef SCALE_BUG
   toneLabel = XtVaCreateManagedWidget ("Tone", xmLabelWidgetClass, txRC,
      XmNalignment, XmALIGNMENT_CENTER,
      NULL);
   #endif

   /*
    * toneScale - scale for Tone  
    */
    toneScale = XtVaCreateManagedWidget ("toneScale", xmScaleWidgetClass, txRC,
      XmNorientation, XmHORIZONTAL,
      XmNminimum, MIN_FREQ,
      XmNmaximum, MAX_FREQ,
      #ifndef SCALE_BUG
      XmNtitleString, XmStringCreateLocalized ("Tone"),
      #endif
      XmNshowValue, True,
      XmNscaleMultiple, 10,
      NULL);

   #ifdef SCALE_BUG
   farnsLabel = XtVaCreateManagedWidget ("Farnsworth - Off",
      xmLabelWidgetClass, txRC,
      XmNalignment, XmALIGNMENT_CENTER,
      NULL);
   #endif

   /*
    * farnsScale - scale for Farnsworth value  
    */
   farnsScale = XtVaCreateManagedWidget ("farnsScale", xmScaleWidgetClass, txRC,
      XmNorientation, XmHORIZONTAL,
      XmNvalue, 4,
      XmNminimum, 4,
      XmNmaximum, 18,
      #ifndef SCALE_BUG
      XmNtitleString, XmStringCreateLocalized ("Farnsworth-Off"),
      #endif
      XmNshowValue, True,
      XmNscaleMultiple, 1,
      NULL);

   /*
    * trFrame - Transmit/Receive frame for Recv/Xmit 
    * and Sidetones radioboxes
    */
   trFrame = XtVaCreateManagedWidget ("trFrame", xmFrameWidgetClass, form2,
      XmNshadowType, XmSHADOW_OUT,
      XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET,
      XmNtopWidget, form4,
      XmNtopOffset, 0,
      XmNleftAttachment, XmATTACH_WIDGET,       
      XmNleftWidget, form4,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_NONE,
      XmNshadowThickness, 3,
      NULL);

   /*
    * form5 - form for T/R and tone radioboxes
    */
   form5 = XtVaCreateWidget ("form5", xmFormWidgetClass, trFrame,
      NULL);

   /*
    * trRC - row column for Xmit/Recv toggle button
    */
   trRC = XtVaCreateWidget ("trRC", xmRowColumnWidgetClass, form5,
      XmNorientation, XmVERTICAL,     
      XmNentryAlignment, XmALIGNMENT_CENTER,
      XmNtopAttachment, XmATTACH_NONE,
      XmNleftAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);

   /*
    * Trans/Recv toggle button
    */
      trTB = XtVaCreateManagedWidget ("Xmit", xmToggleButtonWidgetClass, trRC,
         XmNset, False,
         XmNindicatorOn, XmINDICATOR_NONE,
         XmNshadowThickness, 3,
         XmNmnemonic, 'X',
         NULL);

   /*
    * keyRC - row column radio box for SC and Rig toggle buttons
    */
   keyRC = XtVaCreateWidget ("keyRC", xmRowColumnWidgetClass, form5,
      XmNorientation, XmHORIZONTAL,     
      XmNradioBehavior, True,
      XmNradioAlwaysOne, True,
      XmNtopAttachment, XmATTACH_NONE,
      XmNleftAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_WIDGET,
      XmNbottomWidget, trRC,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);

   /*
    * scTB and rigTB - toggle buttons for SC and RTW selection
    */
   scTB = XtVaCreateManagedWidget ("SC", xmToggleButtonWidgetClass, keyRC,
      NULL);

   rigTB = XtVaCreateManagedWidget ("Rig", xmToggleButtonWidgetClass, keyRC,
      NULL);

   // XmToggleButtonSetState (rigTB, 1, True);

   /*
    * if CWIRC mode, we don't want these TBs to work
    */
   if (mode == CWIRC)
   {
      XtVaSetValues (scTB,
         XmNsensitive, False,
         NULL);
      XtVaSetValues (rigTB,
         XmNsensitive, False,
         NULL);
   }

#if 0   //TJW 2.0
   /*
    * da1 - drawing area for fft data
    */
   da1 = XtVaCreateManagedWidget ("da1", xmDrawingAreaWidgetClass, form2,
      XmNwidth, DA_WIDTH,
      XmNheight, DA_HEIGHT,
      XmNtopOffset, 0,
      XmNtraversalOn, False,
      XmNtopAttachment, XmATTACH_NONE,
      XmNleftAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_WIDGET,
      XmNbottomWidget, form4,
      XmNrightAttachment, XmATTACH_NONE,
      NULL);

   /*
    * label4 for da1 - tuning
    */
   label4 = XtVaCreateManagedWidget ("Tuning", xmLabelWidgetClass, form2,
      XmNwidth, DA_WIDTH,
      XmNtopAttachment, XmATTACH_FORM,
      XmNtopOffset, 0,
      XmNleftAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_WIDGET,
      XmNbottomWidget, da1,
      XmNrightAttachment, XmATTACH_OPPOSITE_WIDGET,
      XmNrightWidget, da1,
      NULL);     

   /*
    * scale2 - scale for Level  
    */
    scale2 = XtVaCreateManagedWidget ("scale2", xmScaleWidgetClass, form2,
      XmNorientation, XmVERTICAL,
      XmNshowValue, True,
      XmNscaleMultiple, 5,
      XmNminimum, 0,
      XmNmaximum, 100,
      XmNvalue, 50,
      XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET,
      XmNtopWidget, da1,
      XmNtopOffset, 0,
      XmNleftAttachment, XmATTACH_WIDGET,
      XmNleftWidget, da1,
      XmNleftOffset, 8,
      XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
      XmNbottomWidget, da1,
      XmNbottomOffset, 0,
      XmNrightAttachment, XmATTACH_NONE,
      NULL);

   /*
    * scale3 - scale for Word  
    */
    scale3 = XtVaCreateManagedWidget ("scale3", xmScaleWidgetClass, form2,
      XmNorientation, XmVERTICAL,
      XmNshowValue, True,
      XmNscaleMultiple, 1,
      XmNminimum, -10,
      XmNmaximum, 10,
      XmNvalue, 0,
      XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET,
      XmNtopWidget, da1,
      XmNtopOffset, 0,
      XmNleftAttachment, XmATTACH_WIDGET,
      XmNleftWidget, scale2,
      XmNleftOffset, 8,
      XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
      XmNbottomWidget, da1,
      XmNbottomOffset, 0,
      XmNrightAttachment, XmATTACH_NONE,
      NULL);

   /*
    * scale4 - scale for Char  
    */
    scale4 = XtVaCreateManagedWidget ("scale4", xmScaleWidgetClass, form2,
      XmNorientation, XmVERTICAL,
      XmNshowValue, True,
      XmNscaleMultiple, 1,
      XmNminimum, -10,
      XmNmaximum, 10,
      XmNvalue, 0,
      XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET,
      XmNtopWidget, da1,
      XmNtopOffset, 0,
      XmNleftAttachment, XmATTACH_WIDGET,
      XmNleftWidget, scale3,
      XmNleftOffset, 8,
      XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
      XmNbottomWidget, da1,
      XmNbottomOffset, 0,
      XmNrightAttachment, XmATTACH_NONE,
      NULL);

   /*
    * label for scale2 - sens
    */
   label5 = XtVaCreateManagedWidget ("Sens", xmLabelWidgetClass, form2,
      XmNtopAttachment, XmATTACH_FORM,
      XmNtopOffset, 0,
      XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET,
      XmNleftWidget, scale2,
      XmNbottomAttachment, XmATTACH_WIDGET,
      XmNbottomWidget, scale2,
      XmNbottomOffset, 0,
      XmNrightAttachment, XmATTACH_OPPOSITE_WIDGET,
      XmNrightWidget, scale2,
      NULL);     

   /*
    * label for scale3 - word
    */
   label6 = XtVaCreateManagedWidget ("Word", xmLabelWidgetClass, form2,
      XmNtopAttachment, XmATTACH_FORM,
      XmNtopOffset, 0,
      XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET,
      XmNleftWidget, scale3,
      XmNbottomAttachment, XmATTACH_WIDGET,
      XmNbottomWidget, scale3,
      XmNbottomOffset, 0,
      XmNrightAttachment, XmATTACH_OPPOSITE_WIDGET,
      XmNrightWidget, scale3,
      NULL);     

   /*
    * label for scale4 - char
    */
   label7 = XtVaCreateManagedWidget ("Char", xmLabelWidgetClass, form2,
      XmNtopAttachment, XmATTACH_FORM,
      XmNtopOffset, 0,
      XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET,
      XmNleftWidget, scale4,
      XmNbottomAttachment, XmATTACH_WIDGET,
      XmNbottomWidget, scale4,
      XmNbottomOffset, 0,
      XmNrightAttachment, XmATTACH_OPPOSITE_WIDGET,
      XmNrightWidget, scale4,
      NULL);     


// for other values
   tf1 = XtVaCreateManagedWidget ("tf1", xmTextFieldWidgetClass, form2,
      XmNcolumns, 5,
      XmNcursorPositionVisible, False,
      XmNtopAttachment, XmATTACH_FORM,
      XmNtopOffset, 0,
      XmNleftAttachment, XmATTACH_NONE,
      XmNbottomAttachment, XmATTACH_NONE,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);

// for other values
   tf2 = XtVaCreateManagedWidget ("tf1", xmTextFieldWidgetClass, form2,
      XmNcolumns, 5,
      XmNcursorPositionVisible, False,
      XmNtopAttachment, XmATTACH_WIDGET,
      XmNtopWidget, tf1,
      XmNleftAttachment, XmATTACH_NONE,
      XmNbottomAttachment, XmATTACH_NONE,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);

// for other values
   tf3 = XtVaCreateManagedWidget ("tf3", xmTextFieldWidgetClass, form2,
      XmNcolumns, 5,
      XmNcursorPositionVisible, False,
      XmNtopAttachment, XmATTACH_WIDGET,
      XmNtopWidget, tf2,
      XmNleftAttachment, XmATTACH_NONE,
      XmNbottomAttachment, XmATTACH_NONE,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);
#endif
   /*
    * form3 - form for text widgets
    */
   form3 = XtVaCreateWidget ("form3", xmFormWidgetClass, form1,
      XmNhorizontalSpacing, SPACING,
      XmNverticalSpacing, SPACING,
      XmNtopAttachment, XmATTACH_WIDGET,
      XmNtopWidget, menuBar,
      XmNbottomAttachment, XmATTACH_WIDGET,
      XmNbottomWidget, form2,
      XmNrightAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_FORM,
      NULL);
         
   /*
    * pane1 - paned window for rx and tx text widgets
    */
    pane1 = XtVaCreateWidget ("pane1", xmPanedWindowWidgetClass, form3,
       XmNtopAttachment, XmATTACH_FORM,
       XmNleftAttachment, XmATTACH_FORM,
       XmNbottomAttachment, XmATTACH_WIDGET,
       XmNbottomWidget, form2,
       XmNrightAttachment, XmATTACH_FORM,
       NULL);

   /*
    * rxText - textfield for rx/sent characters
    * create this widget if in TWCW mode
    */
   if (mode == TWCW)
   {
      i = 0;
      XtSetArg (args[i], XmNeditMode, XmMULTI_LINE_EDIT); i++;
      XtSetArg (args[i], XmNeditable, False); i++;
      XtSetArg (args[i], XmNscrollingPolicy, XmAUTOMATIC); i++;
      XtSetArg (args[i], XmNscrollHorizontal, False); i++;
      XtSetArg (args[i], XmNwordWrap, True); i++;
 
      rxText = XmCreateScrolledText (pane1, "rxText", args, i);     
   }

   /*
    * txText - scrolled text for tx text
    */
   i = 0;
   XtSetArg (args[i], XmNeditMode, XmMULTI_LINE_EDIT); i++;
   XtSetArg (args[i], XmNscrollingPolicy, XmAUTOMATIC); i++;
   XtSetArg (args[i], XmNscrollHorizontal, False); i++;
   XtSetArg (args[i], XmNwordWrap, True); i++;

   txText = XmCreateScrolledText (pane1, "txText", args, i);
   XtManageChild (menuBar);
   XtManageChild (txRC);
   XtManageChild (trRC);
   XtManageChild (keyRC);

   /* 
    * The rxText widget was only created if we are in TWCW mode,
    * so we only want to manage it if we are in TWCW mode
    */
   if (mode == TWCW)
   {
      XtManageChild (rxText);
   }
   XtManageChild (txText);
   XtManageChild (pane1);
   XtManageChild (form5);
   XtManageChild (form4);
   XtManageChild (form3);
   XtManageChild (form2);
   XtManageChild (form1);

   /*
    * Create Popup menu.
    */
   clr_rcvd_xs = XmStringCreateLocalized ("Clear Copy");
   clr_send_xs = XmStringCreateLocalized ("Clear Send");
   reset_xs = XmStringCreateLocalized ("Clear All");
   quit_xs = XmStringCreateLocalized ("QRT");
   clr_rcvd_acc_xs = XmStringCreateLocalized ("Ctrl-C");
   clr_send_acc_xs = XmStringCreateLocalized ("Ctrl-S");
   reset_acc_xs = XmStringCreateLocalized ("Ctrl-A");
   quit_acc_xs = XmStringCreateLocalized ("Ctrl-Q");

   popup = XmVaCreateSimplePopupMenu (form1, "menu", popupCB,
      XmVaPUSHBUTTON, clr_rcvd_xs, 'R', "Ctrl<Key>C", clr_rcvd_acc_xs,
      XmVaPUSHBUTTON, clr_send_xs, 'S', "Ctrl<Key>S", clr_send_acc_xs,
      XmVaPUSHBUTTON, reset_xs, 'A', "Ctrl<Key>A", reset_acc_xs,
      XmVaSEPARATOR,
      XmVaPUSHBUTTON, quit_xs, 'Q', "Ctrl<Key>Q", quit_acc_xs,
      NULL);

   XmStringFree (clr_rcvd_xs);
   XmStringFree (clr_send_xs);
   XmStringFree (reset_xs);
   XmStringFree (quit_xs);
   XmStringFree (clr_rcvd_acc_xs);
   XmStringFree (clr_send_acc_xs);
   XmStringFree (reset_acc_xs);
   XmStringFree (quit_acc_xs);

   /*
    * but if CWIRC mode, we don't want popup "Clear Copy" button to work
    */
   if (mode == CWIRC)
   {
      XtVaSetValues (XtNameToWidget(popup, "button_0"),
         XmNsensitive, False,
         NULL);
   }

   /*
    * Add focus callback for form1 - used to create twcwDir and
    * its files on the fly
    */
   XtAddCallback (form1, XmNfocusCallback, initCB, (XtPointer) NULL);

   /*
    * Add Callbacks, Actions and Event Handlers
    */
   for(i=0; i<cnt; i++)               /* Filename callbacks */
   {
      XtAddCallback (fileBtns[i], XmNactivateCallback, fileCB,
         (XtPointer) i);
   }

   XtAddCallback (fileBtns[i], XmNactivateCallback, quitCB, NULL);
   XtAddCallback (aboutBtn, XmNactivateCallback, aboutCB, NULL);
   XtAddCallback (helpBtn, XmNactivateCallback, helpCB, NULL);

   XtAddCallback (txText, XmNmodifyVerifyCallback, txTextCB, NULL);
   XtAddCallback (txText, XmNvalueChangedCallback, txTextCB, NULL);

   /*
    * These are only valid if in TWCW mode
    */
   if (mode == TWCW)
   {
      XtAddCallback (rxText, XmNmodifyVerifyCallback, rxTextCB, NULL);
      XtAddCallback (rxText, XmNvalueChangedCallback, rxTextCB, NULL);
   }
   
   /* WPM, farns, and tone scales */
   XtAddCallback (wpmScale, XmNvalueChangedCallback, wpmCB, (XtPointer)WPM_MSG);
   XtAddCallback (wpmScale, XmNdragCallback, wpmCB, (XtPointer) WPM_MSG);
   XtAddCallback (farnsScale, XmNvalueChangedCallback, wpmCB, NULL);
   XtAddCallback (farnsScale, XmNdragCallback, wpmCB, NULL);
   XtAddCallback (toneScale, XmNvalueChangedCallback, toneCB, NULL);
   XtAddCallback (toneScale, XmNdragCallback, toneCB, NULL);

   /* rx and tx menu buttons CB */
   XtAddCallback (rxBtn, XmNactivateCallback, controlBtnsCB, (XtPointer) 0);
   XtAddCallback (txBtn, XmNactivateCallback, controlBtnsCB, (XtPointer) 1);

   /* Trans/Recv TB */
   XtAddCallback (trTB, XmNvalueChangedCallback, trCB, (XtPointer) 0);

   /* HACK - A radio box does not allow for accelerator keys, so
    * I added them to buttons in the menu bar.  This menu bar CB calls
    * a function that sets the radiobox button, and the valueChanged
    * CB does the rest.  However, the radiobox can get confused when
    * mouse and acc key are intermixed.  These disarm CBs seem to fix it
    */
  //XtAddCallback (rxBtn, XmNdisarmCallback, controlBtnsCB, (XtPointer) trTB);

   /* Soundcard and Speaker selection */
   XtAddCallback (scTB, XmNvalueChangedCallback, keyTBCB, "1");
   XtAddCallback (rigTB, XmNvalueChangedCallback, keyTBCB, "2");

   /* practice mode */
   XtAddCallback (practiceTB, XmNvalueChangedCallback, practiceTBCB, NULL);

   /* Menubar Recv, Xmit and Reset Btns */
   XtAddCallback (rcvdBtn, XmNactivateCallback, popupCB, (XtPointer) CLR_RCVD);
   XtAddCallback (sendBtn, XmNactivateCallback, popupCB, (XtPointer) CLR_SEND);
   XtAddCallback (resetBtn, XmNactivateCallback, popupCB, (XtPointer) CLR_ALL); 

#if 0  //TJW 2.0
   /* Sensitivity level */
   XtAddCallback (scale2, XmNvalueChangedCallback, scale2CB, NULL);
   XtAddCallback (scale2, XmNdragCallback, scale2CB, NULL);

   /* Word gap */
   XtAddCallback (scale3, XmNvalueChangedCallback, scale3CB, NULL);
   XtAddCallback (scale3, XmNdragCallback, scale3CB, NULL);

   /* Space gap */
   XtAddCallback (scale4, XmNvalueChangedCallback, scale4CB, NULL);
   XtAddCallback (scale4, XmNdragCallback, scale4CB, NULL);
#endif


   XtAddEventHandler (form1,ButtonPressMask,False,input_event,(XtPointer)popup);
   // XtAddEventHandler (txText, EnterWindowMask, False, input_event, NULL);
   if (mode == TWCW)
   {
      XtAddEventHandler (rxText, EnterWindowMask, False, input_event, NULL);
      XtAddEventHandler (rxText, ButtonPressMask, False, input_event, NULL);
   }

   XtAppAddActions (ac, actions, XtNumber(actions));
}
