/*
 * twcw.h Header File
 */
#ifndef INCLUDED_TWCW_H
#define INCLUDED_TWCW_H

/*
 * Include Files
 */
#include <time.h>
#include <ctype.h>
#include <dirent.h>
#include <stdlib.h>
#include <locale.h> 
#include <sys/wait.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/soundcard.h>
#include <X11/cursorfont.h>

#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/CascadeB.h>
#include <Xm/PushB.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/Scale.h>
#include <Xm/DrawingA.h>
#include <Xm/ScrolledW.h>
#include <Xm/Text.h>
#include <Xm/RowColumn.h>
#include <Xm/TextF.h>
#include <Xm/ToggleB.h>
#include <Xm/PanedW.h>
#include <Xm/DialogS.h>
#include <Xm/SelectioB.h>
#include <Xm/MessageB.h>
#include <Xm/Separator.h>
#include <Xm/MwmUtil.h>

// TJW 2.0 #include <rfftw.h>


/*
 * Define Values
 */
#define TWCWDIR  "/.twcwDir"

/* Scale Bug - Scales won't display label and value at the same time.
 * Define this to create labels instead of using the Scale's gadget
 * Used in twcwWids.c and twcwCB.c
 */
#define SCALE_BUG
#define TWO_PI  ((double)2.0 * M_PI)

#define MAKE_ICON
#define NO_CANCEL 1

#ifdef MAKE_ICON
#include <X11/xpm.h>
#endif

#define TWCWDIR          "/.twcwDir"  /* These two need the starting / */
#define HELPFILE         "/twcwHelp"

#define MIN_WPM           8      /* Minimum words per minute */
#define MAX_WPM          50      /* Maximum words per minute */

#define FARNS_OFF         4      /* Farnsworth is off speed  */
#define FARNS_MAX        18      /* Maximum Farnsworth speed */

#define MIN_FREQ        500      /* Minimum freq */
#define MAX_FREQ       1200      /* Maximum freq */

#define CLR_RCVD          0      /* Client Data for popupCB */
#define CLR_SEND          1      /* and buttons on Menu bar's */
#define CLR_ALL           2
#define QRT               3      

#define DMA_BUF_BITS      7
#define AUDIO_PATH        "/dev/dsp"
#define MIXER_PATH        "/dev/mixer"


/* FFT constants */
#define RX_FREQ       1000                              /* rx frequency */
#define SAMPLE_SIZE   1024                              /* sample size and  */
#define SAMPLE_FREQ   44000                             /* sample frequency */
#define BIN_SIZE      (SAMPLE_FREQ / SAMPLE_SIZE / 2.0) /* Hz per fft bin */

#define DA_WIDTH      (int)(2000.0 / BIN_SIZE)
#define DA_HEIGHT     80

#define FILTER        150                               /* filter width */
#define FILTER_WID    FILTER / BIN_SIZE                 /* bins in filter */

/*
 * Application Defined Resources
 */
#define XmNcall            "call"
#define XmCCall            "Call"

#define XmNbuttonNames     "buttonNames"
#define XmCButtonNames     "ButtonNames"

#define XmNcpuSpeed        "cpuSpeed"
#define XmCCpuSpeed        "CpuSpeed"

#define XmNserialDevice    "serialDevice"
#define XmCSerialDevice    "SerialDevice"

#define XmNdspDevice       "dspDevice"
#define XmCDspDevice       "DspDevice"

#define XmNmixerDevice     "mixerDevice"
#define XmCMixerDevice     "MixerDevice"


typedef struct
{
   char *call;
   char **buttonNames;
   char *serialDevice;
   char *dspDevice;
   char *mixerDevice;
} AppRes;

/*
 * sendCW args Structure
 * for passing args to sendCW proc
 */
struct tag2
{
   int  mode;
   char dspdev[20];
   char mixerdev[20];
   char serdev[20];
   char shm_id[20];
};
  
/* 
 * Globals Variables
 */
XtAppContext ac;
struct tag2 cwArgs;

Widget shell, trTB, scTB, rigTB, messDiag;
Widget rxText, txText, wpmScale, farnsScale, toneScale;
Widget practiceTB;
Widget farnsLabel;
//Widget da1;

//TJW
//temp widgets?
//Widget tf1, tf2, tf3;

int qid;                      /* Message queue id */
int pid;                      /* Child process id */
int pcnt;                     /* count practice chars */

char dirpath[100];
char helppath[100];

int audio_fd;

/*
 * Function Declarations
 */
void    build_widgets (Widget, AppRes *, int);
char    *getFile (char *);
void    initCB (Widget, XtPointer, XtPointer);
void    initDiagCB (Widget, XtPointer, XtPointer);
void    popupCB (Widget, XtPointer, XtPointer);
void    txTextCB (Widget, XtPointer, XtPointer);
void    rxTextCB (Widget, XtPointer, XtPointer);
void    keyTBCB (Widget, XtPointer, XtPointer);
void    toneCB (Widget, XtPointer, XtPointer);
void    farnsCB (Widget, XtPointer, XtPointer);
void    wpmCB (Widget, XtPointer, XtPointer);
int     DoProSigns(XmTextVerifyCallbackStruct *, int);
void    MkRoom (XmTextVerifyCallbackStruct *, int);
void    fileCB (Widget, XtPointer, XtPointer);
void    controlBtnsCB (Widget, XtPointer, XtPointer);
void    trCB (Widget, XtPointer, XtPointer);
void    tonesTBCB (Widget, XtPointer, XtPointer);
void    modTextCB (Widget, XtPointer, XtPointer);
void    OkCB (Widget, XtPointer, XtPointer);
void    cancelCB (Widget, XtPointer, XtPointer);
void    input_event (Widget, XtPointer, XEvent *, Boolean *);
void    aboutCB (Widget, XtPointer, XtPointer);
void    helpCB (Widget, XtPointer, XtPointer);
void    practiceTBCB (Widget, XtPointer, XtPointer);
int     getQSOfiles (char *destdir);
void    errorDiag (Widget w, char *emess, int flag);
void    errOkCB (Widget w, XtPointer cdata, XtPointer cbs);

/* sensitivity level */
void    scale2CB (Widget, XtPointer, XtPointer);
void    set_sens (int val);

/* word gap */
void    scale3CB (Widget, XtPointer, XtPointer);
void    set_wordsf (int val);

/* char gap */
void    scale4CB (Widget, XtPointer, XtPointer);
void    set_charsf (int val);

void    quitCB (Widget, XtPointer, XtPointer);
Boolean procData (XtPointer);
void    inputDiag (char *);
int     setup (void);
int     send_msg (long int, char *);
void    cleanup ();
int     fork_sendCW (struct tag2 *);
Boolean do_work (XtPointer);
void    sendOver (Widget w, XEvent *e, String args[], Cardinal *nargs);
void    sendHisCall (Widget w, XEvent *e, String args[], Cardinal *nargs);
void    sendMacro (Widget w, XEvent *e, String args[], Cardinal *nargs);
void    sendPro (Widget w, XEvent *e, String args[], Cardinal *nargs);
char    *getHisCall ();
void    procMacroText (char *ch);

void    init_plan (void);
void    destroy_plan (void);
int     init_audio (void);
void    close_sound (void);
void    init_mixer (void);
void    init_table (void);
void    next_symbol (char sym);
char    get_letter (void);
void    select_loop (void);
// TJW 2.0 void    doRFFTW (unsigned int sample[], fftw_real power[]);
// TJW 2.0 void    decode (fftw_real power[], int lo, int hi);
char    *getFive (char group[]);

#endif
