/*
 * twcw:  A gui application that sends Morse Code 
 * Copyright (C) 1997 Ted Williams WA0EIR 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
 * Versions: 1.4 JAN 2008
 */

#include "common.h"
#include "sendCW.h"
#include "libCW.h"

int cwirc_shm_id;
struct cwirc_extension_api *cwirc_api_shm;

/*
 * main FUNCTION 
 * child process that sends CW via libCW
 * main args - mode, dspdev, mixdev, serdev  
 */
int  main (int argc, char *argv[])
{
   int i;
   int rtn;
   struct tag1 reply;
   struct tag1 message;
   int type = 0;
   int mode;

   /* did you try to execute sendCW standalone? */
   if (argc == 1)
   {
     fprintf (stderr, "%s can not run standalone.\n", argv[0]);
     fprintf (stderr, "It must be started by running twcw.\n");
     exit (1);
   }

   mode = atoi (argv[1]);
   /*
    * Check to see if we are using TWCW or CWIRC mode 
    */
   switch (mode)
   {
      case TWCW:
         /* initialize libCW */
         fprintf (stderr, "sendCW: using TWCW mode\n");
         cw_init (argv[2], argv[3], argv[4]);
         cw_set_key_modes (RTS);            /* hard coded for Rig/RTS */
         cw_set_reply_msg (TRUE);
         break;

      case CWIRC:
         fprintf (stderr, "sendCW: using CWIRC mode\n");
         cw_init (NULL, NULL, argv[4]);
         cw_set_key_modes (IRC);
         cwirc_shm_id = strtol (argv[5], NULL, 0);  /* arg[5] is cwirc_shm_id */
         cwirc_api_shm = shmat(cwirc_shm_id,NULL,0);  /* attach shared mem */
         cw_set_reply_msg (TRUE);
         if (cwirc_api_shm == (struct cwirc_extension_api *) -1)
         {
            fprintf(stderr, "sendCW: Can't attach the CWirc shared memory\n");
         }
         break;

      default:
         fprintf (stderr, "sendCW - Invalid mode - must CWIRC or TWCW\n");
         exit (1);
   }


   /*
    * connect to the message queue
    */
   if ((qid = msgget (TWCW_KEY, 0666)) < 0)
   {
      perror ("msgget");
      exit (1);
   }
   /*
    * Read a Message From the Queue
    */
   while (TRUE)
   {
      rtn = msgrcv (qid, (struct msgbuf *) &message, MAX_WORD_LENGTH, type, 0);
      if (rtn < 0 && errno == EAGAIN)
      {
         perror ("send_cw - msgrcv failed");
      }
      switch (message.type)
      {
         case WORD_MSG:                      /* Got a word to send */
            i=0;
            while (message.data.word[i] != '\0')
            {
               /* send cw and send each char back to the gui */
               cw_send_char (message.data.word[i]);
               i++;
            }
            continue;

         case WPM_MSG:                       /* Sets a new WPM */
            cw_set_wpm(message.data.val);

            /* Tell the GUI we are done setting WPM */
            reply.type = WPM_DONE;
            reply.data.word[0] = 'w';
            reply.data.word[1] = (char) NULL;

            if (msgsnd (qid, (struct msgbuf *) &reply,
                sizeof (reply.data), 0) == -1)
            {
               perror ("send_cw - msgsnd WPM_DONE failed");
               cleanup();
               exit (1);
            }
            continue;

         case FARNS_MSG:                     /* set Farnsworth value */
            cw_set_fwpm (message.data.val);
            continue;

         case FREQ_MSG:
            cw_set_freq(message.data.val);
            continue;

         case KEY_DEVICES_MSG:
            cw_set_key_modes (message.data.val);
            continue;

         case STOP_MSG:
            if (message.data.word[0] == '0')
            {
               type = -STOP_MSG;             /* Stop sending */ 
            }
            else
            {
               type = -WORD_MSG;             /* Start sending */
            }
      }
   }
   exit (0);
}
