
/*
 * twclockDiags:  A world clock implemented with openMotif widgets
 * Copyright (C) 1997 - 2007 Ted Williams WA0EIR
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have recieved a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge. MA 02139, USA.
 * See the COPYING file in this directory.
 *
 * Versions: 2.8 -  Dec 2007
 */

#include "twclock.h"
#include "twclockHelp.h"
/*
 * aboutDiag Function
 * Just an about dialog box
 */
void popup_about()
{
   static Widget diag = NULL;
   Widget pb;
   XmString msg_xs;
   char msg_str[] =
      "twclock \251 2007 was written by\nTed Williams - WA\330EIR";

   if (diag == NULL)
   {
      msg_xs = XmStringCreateLtoR (msg_str, XmSTRING_DEFAULT_CHARSET);

      diag = XmCreateInformationDialog (clock_shell, "aboutDiag",
        (ArgList) NULL, 0);

      XtVaSetValues (XtParent (diag),
         XmNtitle, "ABOUT TWLOG",
         NULL);

      XtVaSetValues (diag,
         XmNmessageAlignment, XmALIGNMENT_CENTER,
         XmNmessageString, msg_xs,
         NULL);
      XmStringFree (msg_xs);

      XtUnmanageChild (XmMessageBoxGetChild (diag, XmDIALOG_CANCEL_BUTTON));
      XtUnmanageChild (XmMessageBoxGetChild (diag, XmDIALOG_HELP_BUTTON));
      XtUnmanageChild (XmMessageBoxGetChild (diag, XmDIALOG_OK_BUTTON));

      pb = XtVaCreateManagedWidget ("OK", xmPushButtonWidgetClass, diag,
         NULL);
   }
   XtManageChild (diag);
}


/*
 * Help Dialog
 */
void popup_help (void)
{
   int i;
   static Widget helpDiag = 0;
   static Widget helpLabel, closePB, sep, helpTextSW;
   Arg args[20];

   if (helpDiag == NULL)
   {
      helpDiag = XmCreateFormDialog (clock_shell, "helpDiag", NULL, 0);

      XtVaSetValues (helpDiag,
        XmNdialogStyle, XmDIALOG_MODELESS,
        XmNverticalSpacing, 10,
        XmNhorizontalSpacing, 10,
        NULL);

      XtVaSetValues (XtParent (helpDiag),       /* set title bar */
         XmNtitle, "TWCLOCK HELP",
         NULL);

      helpLabel = XtVaCreateManagedWidget ("TWCLOCK HELP", xmLabelWidgetClass,
         helpDiag,
         XmNtopAttachment, XmATTACH_FORM,
         XmNleftAttachment, XmATTACH_FORM,
         XmNbottomAttachment, XmATTACH_NONE,
         XmNrightAttachment, XmATTACH_FORM,
         NULL);

      closePB = XtVaCreateManagedWidget ("Close", xmPushButtonWidgetClass,
         helpDiag,
         XmNtopAttachment, XmATTACH_NONE,
         XmNleftAttachment, XmATTACH_POSITION,
         XmNleftPosition, 40,
         XmNrightAttachment, XmATTACH_POSITION,
         XmNrightPosition, 60,
         XmNbottomAttachment, XmATTACH_FORM,
         NULL);

      sep = XtVaCreateManagedWidget ("sep", xmSeparatorWidgetClass, helpDiag,
         XmNtopAttachment, XmATTACH_NONE,
         XmNleftAttachment, XmATTACH_FORM,
         XmNbottomAttachment, XmATTACH_WIDGET,
         XmNbottomWidget, closePB,
         XmNrightAttachment, XmATTACH_FORM,
         NULL);

      i = 0;
      XtSetArg (args[i], XmNrows, 12);  i++;
      XtSetArg (args[i], XmNcolumns, 50);  i++;
      XtSetArg (args[i], XmNeditMode, XmMULTI_LINE_EDIT);  i++;
      XtSetArg (args[i], XmNeditable, False);  i++;
      XtSetArg (args[i], XmNscrollHorizontal, False);  i++;
      XtSetArg (args[i], XmNwordWrap, True);  i++;
      XtSetArg (args[i], XmNtopAttachment, XmATTACH_WIDGET);  i++;
      XtSetArg (args[i], XmNtopWidget, helpLabel);  i++;
      XtSetArg (args[i], XmNleftAttachment, XmATTACH_FORM);  i++;
      XtSetArg (args[i], XmNbottomAttachment, XmATTACH_WIDGET);  i++;
      XtSetArg (args[i], XmNbottomWidget, sep);  i++;
      XtSetArg (args[i], XmNrightAttachment, XmATTACH_FORM);  i++;
      XtSetArg (args[i], XmNvalue, helpText); i++;

      helpTextSW = XmCreateScrolledText (helpDiag, "helpTextSW", args, i);

      XtManageChild (helpTextSW);

   }
   XtManageChild (helpDiag);    /* pop it up */
}
