/* $Id: syscall.c,v 1.11 2000/05/15 11:26:49 malekith Exp $ */

#include "h.h"

#include <syscall.h>
#include <sys/time.h>

int errno;

_syscall3(int,write,int,fd,const void *,buf,int,count)
_syscall3(int,read,int,fd,void *,buf,int,count)
_syscall3(int,ioctl,int,fd,int,req,void *,buf)
_syscall1(void*,brk,void*,end)
_syscall0(int,getuid)
_syscall0(pid_t,getpid)
_syscall0(pid_t,getppid)
_syscall2(int,kill,pid_t,pid,int,sig)
_syscall0(int,fork)
_syscall4(pid_t,wait4,pid_t,pid,int *,wait_stat,int,options,struct rusage *,rusage)
_syscall3(int,execve,const char *,file,char **,argv,char **,envp)
_syscall1(int,close,int,fd)
_syscall3(int,open,const char *,name,int,xx,int,mode)
_syscall1(int,chdir,char*,f)
_syscall2(int,munmap,void *,start,size_t,length)
_syscall4(void *,mremap,void *,old_address,size_t,old_size,size_t,new_size, unsigned long, flags)
_syscall2(int,getcwd,char*,buf,int,len)
_syscall1(int,pipe,int*,fd)
_syscall3(int,fcntl,int,fd,int,cmd,long,arg)
_syscall2(int,dup2,int,fd1,int,fd2)
_syscall3(int,sigaction,int,signum, const struct sigaction *,act, struct sigaction *,oldact)
_syscall2(int,gettimeofday,struct timeval*,tv,struct timezone*,tz)

long xtime(void)
{
	struct timeval tv;
	gettimeofday(&tv, 0);
	return tv.tv_sec;
}
       
#define __NR_xmap __NR_mmap
static inline _syscall1(long,xmap,unsigned long *,buffer);
void *mmap(void *addr, size_t len, int prot, int flags, int fd, off_t off)
{
	unsigned long buffer[6];

	buffer[0] = (unsigned long)addr;
	buffer[1] = (unsigned long)len;
	buffer[2] = (unsigned long)prot;
	buffer[3] = (unsigned long)flags;
	buffer[4] = (unsigned long)fd;
	buffer[5] = (unsigned long)off;
	return (void *) xmap(buffer);
}
		     
/* avoid stupid warning about noreturn func, that returns */
#define __NR_trabka 1
static _syscall1(int,trabka,int,s)

void exit(int x)
{
	trabka(x);
	for(;;){}
}


/* trash.c */
extern int main(int argc, char **argv);

char **environ;

void _start(int x)
{
	void *p;
	char **argv;
	int argc;
	
	p = &x;
	
	argv = (char**)p;
	argc = ((int*)p)[-1];
	environ = p + (argc + 1) * sizeof(char*);
	
	if (argv[0] == 0)
		exit(0);

	exit(main(argc, argv));
}
