/* $Id: parser.c,v 1.27 2000/05/15 16:45:56 malekith Exp $ */

#include "h.h"

/* env.c */
void delete_export_once(void);

struct parser_state {
	char *p; 		/* parsed string */
	struct arg *head, *prev, *cur;
	int dead;
};

#define CTX struct parser_state

char *ifs = " \t\n";
extern char **positional;

int issep(int c)
{
	return c && strchr(ifs, c) != 0;
}

static void parse_error(CTX *ctx, int id)
{
	const char *m;
	m = ctx->p && *ctx->p ? ctx->p : "\\n";
	/* TODO: [%d] only if wizard mode */
	perr("parse error near : '%s' [%d]", m, id);
	ctx->dead = 2;
	if (ctx->p)
		*ctx->p = 0;
}

static void add_chars(CTX *ctx, int noredir);

static void parse_redir(CTX *ctx)
{
	int c1, c2;
	char *p;
	struct arg *a;
	
	p = ctx->p;
	c1 = *p;
	a = ctx->cur;
	
	a->redir_fd = a->val[0] ? atoi(a->val) : (c1 == '<' ? 0 : 1);
	
	if (a->redir_fd > 10) {
		perr("descriptors bigger then 10 cannot be redirected");
		ctx->dead = 2;
		return;
	}
	
	if (!(c2 = *++p)) {
		ctx->p = p;
		parse_error(ctx, 1);
		return;
	}
	p++;
	if (c2 == '&')
		a->flags = 0;
	else if (c1 == '<' && c2 == '>')
		a->flags = O_RDWR;
	else if (c1 == '>' && c2 == '>')
		a->flags = O_WRONLY | O_CREAT | O_APPEND;
	else if (c1 == '>' && c2 == '|')	/* ksh comp. */
		a->flags = O_WRONLY | O_CREAT | O_TRUNC;
	else if (c1 == '>')
		a->flags = O_WRONLY | O_CREAT | O_TRUNC, p--;
	else if (c1 == '<')
		a->flags = O_RDONLY, p--;
	else
		oops();
	while (issep(*p))
		p++;
	if (!*p || (c2 == '&' && (*p < '0' || *p > '9'))) {
		ctx->p = p;
		parse_error(ctx, 2);
		return;
	}
	if (c2 == '&') {
		a->target_fd = atoi(p);
		while (*p >= '0' && *p <= '9')
			p++;
		a_align(a_arg);
		a->val[0] = 0;
		ctx->p = p;
	} else {
		a->target_fd = -1;
		/* allow ``command > 'strange file 'name" isn't"\ "it?"'' */
		ctx->p = p;
		add_chars(ctx, 1);	
	}
	a->type = T_REDIR;
}

static int setup_chars(CTX * ctx)
{
	char *p;
	
	p = ctx->p;
	
	while (*p != '\n' && issep(*p))
		p++;

	if (*p == '\'' || *p == 0) {
		/* eos || expand() signalized verbatim word */
		char *d;
		d = ctx->cur->val;
		if (*p) {
			int l = strlen(++p);
			a_alloc(a_arg, l + 1);
			strcpy(d, p);
			ctx->p = p + l + 1;
	WIZARD(8, "xxxp='%s' %d\n",ctx->p,l);
		} else {
			*d = 0;
			ctx->p = 0;	/* mark eos */
			
			ctx->cur->terminator = '\n';
			ctx->cur->type = T_TERMINATOR;
		}
		a_align(a_arg);
		return 1;
	}
	ctx->p = p;
	return 0;
}

static void add_chars(CTX * ctx, int noredir)
{
	int only_digits = 1, pattern = 0;
	char *d, *p;
	struct arg *a;

	if (setup_chars(ctx))
		return;
		
	a = ctx->cur;
	d = a->val;
	p = ctx->p;

	for (; *p && (*p == '\n' || !issep(*p)); p++)
		switch (*p) {
		case '\'': oops();	/* should be cought above */
		case '"': oops();	/* cannot be produced by expand() */
		case '*':
		case '?':
			pattern = 1;
			goto plain;
		case '\\':
			if (!*++p) 
				goto halt; /* some weird thing happen here */
			else 
				goto plain;
			break;
		case '=':
			a->type = T_ASSIGN;
			goto plain;
		case '>':
		case '<':
			if (noredir)
				goto halt;
			/* for 2> /dev/null */
			if (only_digits) {
				*d = 0;
				ctx->p = p;
				parse_redir(ctx);
				return;
			} else
				goto plain_term;
		case '&':
		case '|':
		case ';':
			if (p[1] == *p && d == a->val) {
				/* we got ;;, || or && */
			    	p += 2;
				a->terminator = *p == '|' ? 'o' : (*p == '&' 
							  ? 'a' : 'c');
				a->type = T_TERMINATOR;
				goto halt;
			} else
				goto plain_term;
		case ')':
		case '(':
		case '\n':
		plain_term:
			if (d == a->val) {
				/* begining ? */
				a->terminator = *p == '\n' ? ';' : *p;
				a->type = T_TERMINATOR;
				p++;
			}
			goto halt;
		default:
		plain:
			a_alloc(a_arg, 1);
			*d++ = *p;
			if (*p < '0' || *p > '9')
				only_digits = 0;
			break;
		}

halt:
	*d = 0;
	a_align(a_arg);
	ctx->p = p;
	
	/*if (pattern)
		filename_exp(ctx);*/
}


void execute(struct arg *head, int do_fork);
void block_child(int doblock);
char *expand(const char *p);

char *copy_exp(const char *p)
{
	char *ret, *d;
	ret = d = alloc(2);
	
	while (*p) {
		if (*p == '\'') {
			alloc(strlen(p) + 1);
			strcpy(d, p);
			d = strchr(d, 0) + 1;
			p = strchr(p, 0) + 1;
		} else {
			alloc(1);
			*d++ = *p++;
		}
	}
	alloc(2);
	*d++ = 0;
	*d++ = 0;
	*d = 0;		/* just in case ;) */
	return ret;
}

static void load_p(CTX *ctx, const char *p)
{
	char *z = 0;
	
	if (!p) {
		ctx->p = 0;
		return;
	}
	
	a_push_state(a_arg); /* don't pollute a_arg */
	p = expand(p);
	if (p)
		z = copy_exp(p);
	a_pop_state(a_arg);
	ctx->p = z;
}

static void validate_terminator(CTX *ctx)
{
	switch (ctx->cur->terminator) {
		/* '(' must be first or follow terminator */
	case '(':
		if (ctx->prev && !ctx->prev->terminator)
			parse_error(ctx, 3);
		break;
	case ')':
		break;
	case '\n':
	case ';':
		/* can't have ``cmd |'', ``cmd &&'', ``cmd ||''
		 * while can have ``cmd ;'' ``( cmd )'', ``cmd &'' 
		 */
		if (ctx->prev && (ctx->prev->terminator == '|' ||
				  ctx->prev->terminator == 'a' ||
				  ctx->prev->terminator == 'o')) 
			parse_error(ctx, 5);
		break;
	case 0:
		break;
	case '&':
	case 'a':
	case 'o':
	case '|':
		if (!ctx->prev)
			parse_error(ctx, 7);
		/* fall through */
	default:
		/* two terminators cannot occur one after other,
		 * except ')' */
		if (ctx->prev && ctx->prev->terminator && 
		    ctx->prev->terminator != ')')
			parse_error(ctx, 8);
		break;
	}
}

static void link_item(CTX *ctx)
{
	if (ctx->prev)
		ctx->prev->next = ctx->cur;
	ctx->prev = ctx->cur;
	if (ctx->head == 0)
		ctx->head = ctx->cur;
	ctx->cur->next = 0;
}

static void add_item(CTX *ctx)
{
	ctx->cur = a_alloc(a_arg, sizeof(struct arg) + 2);

	ctx->cur->terminator = 0;
	ctx->cur->redir_fd = -1;
	ctx->cur->type = T_NORMAL;

	add_chars(ctx, 0);

	if (ctx->dead)
		return;

	validate_terminator(ctx);
	
	if (ctx->dead)
		return;
		
	link_item(ctx);

	if (ctx->p == 0)
		ctx->dead = 1;
}

/* called also from within control structures parsers. alloc_free() should 
 * be called after typical
 * parse(getline(1));
 * to limit memory usage */
struct arg *parse(const char *p)
{
	CTX xctx, *ctx = &xctx;
	memset(ctx, 0, sizeof(*ctx));
	
	load_p(ctx, p);
	
	if (!ctx->p)
		return 0;
		
	while (!ctx->dead)
		add_item(ctx);
	
	if (ctx->dead == 2)
		return 0;
	
	return ctx->head;
}

/* exec() expects its arg to be alloc'ed, higher level procs cannot use
 * main alloc stack, as well as a_arg stack, since they will get freed
 * here.
 * it WON'T return if (dont_fork) */
void exec(const char *p, int dont_fork)
{
	struct arg *a;
	
	block_child(1);
	
	a = parse(p);
	
	alloc_free();	/* release memory taken by parse */

	if (a == 0)
		error_lev++;
	else if (a->terminator != '\n')
		execute(a, !dont_fork);

	if (dont_fork) 
		exit(127); /* must be error of some kind if we got here */
	
	delete_export_once(); /* remove one time ``NAME=val cmd'' */
	
	a_free(a_arg); /* free up any memory we could have allocated */	
	alloc_free();
	
	block_child(0); /* unblock sigchild in interactive env */
}
