/* $Id: lib.c,v 1.17 2000/05/11 22:26:52 malekith Exp $ */

#include "h.h"

#include <asm/signal.h>

static inline void printf_s(char **d, char *s)
{
	int k;
	if (!s) s = "(null)";
	k = strlen(s);
	alloc(k);
	memcpy(*d, s, k);
	*d += k;
}

static inline void printf_u(char **d, unsigned int v)
{
	char buf[100], *p;

	if (v == 0) {
		*(*d)++ = '0';
		alloc(1);
		return;
	}
	
	for (p = buf + 99; v; v /= 10)
		*p-- = '0' + (v % 10);
		
	v = buf + 99 - p++;
	alloc(v);
	memcpy(*d, p, v);
	*d += v;
}

static inline void printf_d(char **d, int v)
{
	if (v < 0) {
		*(*d)++ = '-';
		alloc(1);
		v = -v;
	}
	printf_u(d, v);
}

static inline void printf_x(char **d, unsigned int v)
{
	static char hex[] = "0123456789abcdef";
	int k;
	
	alloc(8);
	for (k = 8; k--; v >>= 4)
		(*d)[k] = hex[v&0xf];
	*d += 8;
}

static inline void printf_i(char **d, int v)
{
	const char *x = "stn0", *xx = " \t\n";
	char *p;
	
	p = strchr(xx, v);
	if (p) {
		alloc(2);
		*(*d)++ = '\\';
		*(*d)++ = x[p-xx];
	} else {
		alloc(1);
		*(*d)++ = v;
	}
}

char *vsprintf(const char *fmt, void *vp)
{
	void **ap;
	const char *s;
	char *r, *d;

	ap = (void **) vp;
	d = r = alloc(3);
	s = fmt;
	while (*s) {
		if (*s != '%')
			goto copy;
		
		switch (*++s) {
		case 's': printf_s(&d, (char*)(*ap++)); s++; continue;
		case 'd': printf_d(&d, (int)(*ap++)); s++; continue;
		case 'p': /* ptr, to avoid gcc warn */
		case 'x': printf_x(&d, (unsigned int)(*ap++)); s++; continue;
		case 'u': printf_u(&d, (unsigned int)(*ap++)); s++; continue;
		case 'i': printf_i(&d, (int)(*ap++)); s++; continue;
		case 'c': alloc(1); *d++ = (int)(*ap++); s++; continue;
		case '%':
		default:
			goto copy;
		}
	      copy:
		*d++ = *s++;
		alloc(1);
	}
	*d = 0;
	align();
	return r;
}

char *strdup(const char *s)
{
	char *r;
	r = alloc(strlen(s) + 1);
	strcpy(r, s);
	align();
	return r;
}

char *pstrdup(const char *s)
{
	char *r;
	r = palloc(strlen(s) + 1);
	strcpy(r, s);
	align();
	return r;
}

char *strndup(const char *s, int n)
{
	char *r;
	
	r = alloc(n + 1);
	strncpy(r, s, n);
	r[n] = 0;
	align();
	return r;
}

int atoi(const char *p)
{
	int r = 0, n = 1;
	if (!p) return 0;
	while (isspace(*p))
		p++;
	if (*p == '-') {
		n = -1;
		p++;
	}
	while (*p >= '0' && *p <= '9') {
		r *= 10;
		r += *p - '0';
		p++;
	}
	return r * n;
}

char *sprintf(const char *fmt, ... )
{
	return vsprintf(fmt,get_ap(fmt));
}

void printf(const char *fmt, ... )
{
	puts(vsprintf(fmt,get_ap(fmt)));
}

void vprintf(const char *fmt, void *ap )
{
	puts(vsprintf(fmt,ap));
}

char *cwd(void)
{
	char buf[PATH_MAX + 1];
	if (getcwd(buf, PATH_MAX) == -1)
		return 0;
	else
		return strdup(buf);
}

int isspace(int c)
{
	switch (c) {
	case ' ':
	case '\t':
	case '\n':
	case '\r':
	case '\f':
	case '\v':
		return 1;
	default:
		return 0;
	}
}

int isalnum(int c)
{
	return ((c | 0x20) >= 'a' && (c | 0x20) <= 'z') ||
	    (c >= '0' && c <= '9');
}


/* msg.c */
void puts(const char *p)
{
	write(1, p, strlen(p));
}

void eputs(const char *p)
{
	write(2, p, strlen(p));
}


void perr(char *fmt, ... )
{
	char *s, *s2;
	
	s2 = vsprintf(fmt, get_ap(fmt));
	
	if (script)
		s = sprintf("%s[%d]: %s\n", script, line, s2);
	else
		s = sprintf("%s: %s\n", our_name, s2);

	eputs(s);
}

void perror(char *fmt, ... )
{
	char *s, *s2;
	int e;
	
	e = errno;
	s2 = vsprintf(fmt, get_ap(fmt));
	
	if (script)
		s = sprintf("%s[%d]: %s: %s\n", script, line, s2, strerror(e));
	else
		s = sprintf("%s: %s: %s\n", our_name, s2, strerror(e));

	eputs(s);
}

static unsigned int rand_seed;

void srand(unsigned int s)
{
	rand_seed = s;
}

unsigned int rand(void)
{
	int r;
	/* constants arn't accidential, taken from 
	 * Bruce Schneier: Applied Cryptography.
	 * but DONT use it for actual cryptography ;) */
	r = rand_seed = ((rand_seed << 12) + 150889 ) % 714025;
	r |= ((rand_seed = ((rand_seed << 12) + 150889 ) % 714025) << 16);
	return r;
}

void abort()
{
	kill(getpid(),SIGABRT);
	/* that would be sytrange if we got here... but gcc doesn't know
	 * that */
	exit(2);
}

#ifndef SMALL
void assert_fail(const char *name, const char *file, int line,
		 const char *func)
{
	perr("%s:%d: assertion ``%s'' failed in function %s", file, line,
	     name, func);
	abort();
}
#endif

#include "errlist.h"

char *strerror(int n)
{
	if (n < NERR)
		return sprintf("%s", sys_errlist[n]);
	else
		return sprintf("errno=%d", n);
}

int highest_fd;

int hopen(const char *path, int flags, int mode)
{
	int fd, nfd, e;
	fd = open(path, flags, mode);
	if (fd == -1)
		return -1;
	nfd = fcntl(fd, F_DUPFD, 11);
	e = errno;
	close(fd);
	errno = e;
	if (nfd == -1)
		return -1;
	fcntl(nfd, F_SETFD, FD_CLOEXEC);
	if (nfd > highest_fd)
		highest_fd = nfd;
	return nfd;
}
