/* lib.c */
char *vsprintf(const char *fmt, void *vp);
char *strdup(const char *s);
int atoi(const char *p);
char *sprintf(const char *fmt, ... );
void printf(const char *fmt, ... );
void vprintf(const char *fmt, void *ap );
char *cwd(void);
char *strndup(const char *s, int n);
char *pstrdup(const char *s);

int isspace(int c);
int isalnum(int c);

void srand(unsigned int s);
unsigned int rand();

/* message printing */
void puts(const char *p);
void eputs(const char *p);
void perror(char *fmt, ... );
char *strerror(int n);
void perr(char *fmt, ... );

/* env.c */
char *getenv(const char *n);
char **buildenv(void);
void setupenv(void);
/* use putenv("VAR", 0) to unset */
void putenv(const char *n, const char *v);
void putenv_f(const char *n, const char *v, int f);
/* add string NAME=value */
void putenv_eq(const char *s, int flags);
void set_env_flags(const char *n, int f);
int get_env_flags(const char *n);

#define ENV_EXPORT		0x00000001
#define ENV_EXPORT_ONCE		0x00000002

/* match.c */
int matches(const char *val, const char *pattern);
void match_free(void);
int match(const char *val);
int match_start(const char *pattern);

/* string.c */

#ifndef INLINE_STRING
char *strcpy(char *d, const char *s);
char *strchr(const char *p, int c);
int strcmp(const char *a, const char *b);
int strncmp(const char *a, const char *b, size_t n);
void *memcpy(void *p, const void *s, size_t n);
void *memmove(void *p, const void *s, size_t n);
unsigned int strlen(const char *p);
char *strncpy(char *d, const char *s, size_t n);
void *memset(void *p, int c, size_t n);
#endif

/* line-eaters.c */
void gl_push(int fd);
void gl_pop(void);
char *getline(int cont);

/* open file with fd > 10 */
int hopen(const char *name, int xx, int mode);
