#ifdef ERR_INCLUDE
#	ifdef ERR_LONG
#		define ERR(longname, shortname) longname,
#	else /* ERR_LONG */
#		define ERR(longname, shortname) shortname,
#	endif /* ERR_LONG */
#else /* ERR_INCLUDE */
#	define ERR(longname, shortname) 
#endif /* ERR_INCLUDE */

const char *const sys_errlist[] = {
ERR("Success", "Success")
ERR("Operation not permitted", "EPERM")
ERR("No such file or directory", "ENOENT")
ERR("No such process", "ESRCH")
ERR("Interrupted system call", "EINTR")
ERR("I/O error", "EIO")
ERR("No such device or address", "ENXIO")
ERR("Arg list too long", "E2BIG")
ERR("Exec format error", "ENOEXEC")
ERR("Bad file number", "EBADF")
ERR("No child processes", "ECHILD")
ERR("Try again", "EAGAIN")
ERR("Out of memory", "ENOMEM")
ERR("Permission denied", "EACCES")
ERR("Bad address", "EFAULT")
ERR("Block device required", "ENOTBLK")
ERR("Device or resource busy", "EBUSY")
ERR("File exists", "EEXIST")
ERR("Cross-device link", "EXDEV")
ERR("No such device", "ENODEV")
ERR("Not a directory", "ENOTDIR")
ERR("Is a directory", "EISDIR")
ERR("Invalid argument", "EINVAL")
ERR("File table overflow", "ENFILE")
ERR("Too many open files", "EMFILE")
ERR("Not a typewriter", "ENOTTY")
ERR("Text file busy", "ETXTBSY")
ERR("File too large", "EFBIG")
ERR("No space left on device", "ENOSPC")
ERR("Illegal seek", "ESPIPE")
ERR("Read-only file system", "EROFS")
ERR("Too many links", "EMLINK")
ERR("Broken pipe", "EPIPE")
#ifdef ERR_ALL
ERR("Math argument out of domain of func", "EDOM")
ERR("Math result not representable", "ERANGE")
ERR("Resource deadlock would occur", "EDEADLK")
ERR("File name too long", "ENAMETOOLONG")
ERR("No record locks available", "ENOLCK")
ERR("Function not implemented", "ENOSYS")
ERR("Directory not empty", "ENOTEMPTY")
ERR("Too many symbolic links encountered", "ELOOP")
ERR("Operation would block", "EWOULDBLOCK")
ERR("No message of desired type", "ENOMSG")
ERR("Identifier removed", "EIDRM")
ERR("Channel number out of range", "ECHRNG")
ERR("Level 2 not synchronized", "EL2NSYNC")
ERR("Level 3 halted", "EL3HLT")
ERR("Level 3 reset", "EL3RST")
ERR("Link number out of range", "ELNRNG")
ERR("Protocol driver not attached", "EUNATCH")
ERR("No CSI structure available", "ENOCSI")
ERR("Level 2 halted", "EL2HLT")
ERR("Invalid exchange", "EBADE")
ERR("Invalid request descriptor", "EBADR")
ERR("Exchange full", "EXFULL")
ERR("No anode", "ENOANO")
ERR("Invalid request code", "EBADRQC")
ERR("Invalid slot", "EBADSLT")
ERR("File locking deadlock error", "EDEADLOCK")
ERR("Bad font file format", "EBFONT")
ERR("Device not a stream", "ENOSTR")
ERR("No data available", "ENODATA")
ERR("Timer expired", "ETIME")
ERR("Out of streams resources", "ENOSR")
ERR("Machine is not on the network", "ENONET")
ERR("Package not installed", "ENOPKG")
ERR("Object is remote", "EREMOTE")
ERR("Link has been severed", "ENOLINK")
ERR("Advertise error", "EADV")
ERR("Srmount error", "ESRMNT")
ERR("Communication error on send", "ECOMM")
ERR("Protocol error", "EPROTO")
ERR("Multihop attempted", "EMULTIHOP")
ERR("RFS specific error", "EDOTDOT")
ERR("Not a data message", "EBADMSG")
ERR("Value too large for defined data type", "EOVERFLOW")
ERR("Name not unique on network", "ENOTUNIQ")
ERR("File descriptor in bad state", "EBADFD")
ERR("Remote address changed", "EREMCHG")
ERR("Can not access a needed shared library", "ELIBACC")
ERR("Accessing a corrupted shared library", "ELIBBAD")
ERR(".lib section in a.out corrupted", "ELIBSCN")
ERR("Attempting to link in too many shared libraries", "ELIBMAX")
ERR("Cannot exec a shared library directly", "ELIBEXEC")
ERR("Illegal byte sequence", "EILSEQ")
ERR("Interrupted system call should be restarted", "ERESTART")
ERR("Streams pipe error", "ESTRPIPE")
ERR("Too many users", "EUSERS")
ERR("Socket operation on non-socket", "ENOTSOCK")
ERR("Destination address required", "EDESTADDRREQ")
ERR("Message too long", "EMSGSIZE")
ERR("Protocol wrong type for socket", "EPROTOTYPE")
ERR("Protocol not available", "ENOPROTOOPT")
ERR("Protocol not supported", "EPROTONOSUPPORT")
ERR("Socket type not supported", "ESOCKTNOSUPPORT")
ERR("Operation not supported on transport endpoint", "EOPNOTSUPP")
ERR("Protocol family not supported", "EPFNOSUPPORT")
ERR("Address family not supported by protocol", "EAFNOSUPPORT")
ERR("Address already in use", "EADDRINUSE")
ERR("Cannot assign requested address", "EADDRNOTAVAIL")
ERR("Network is down", "ENETDOWN")
ERR("Network is unreachable", "ENETUNREACH")
ERR("Network dropped connection because of reset", "ENETRESET")
ERR("Software caused connection abort", "ECONNABORTED")
ERR("Connection reset by peer", "ECONNRESET")
ERR("No buffer space available", "ENOBUFS")
ERR("Transport endpoint is already connected", "EISCONN")
ERR("Transport endpoint is not connected", "ENOTCONN")
ERR("Cannot send after transport endpoint shutdown", "ESHUTDOWN")
ERR("Too many references: cannot splice", "ETOOMANYREFS")
ERR("Connection timed out", "ETIMEDOUT")
ERR("Connection refused", "ECONNREFUSED")
ERR("Host is down", "EHOSTDOWN")
ERR("No route to host", "EHOSTUNREACH")
ERR("Operation already in progress", "EALREADY")
ERR("Operation now in progress", "EINPROGRESS")
ERR("Stale NFS file handle", "ESTALE")
ERR("Structure needs cleaning", "EUCLEAN")
ERR("Not a XENIX named type file", "ENOTNAM")
ERR("No XENIX semaphores available", "ENAVAIL")
ERR("Is a named type file", "EISNAM")
ERR("Remote I/O error", "EREMOTEIO")
ERR("Quota exceeded", "EDQUOT")
ERR("No medium found", "ENOMEDIUM")
ERR("Wrong medium type", "EMEDIUMTYPE")
#endif /* ERR_ALL */
0
};
#define NERR (int)(sizeof(sys_errlist) / sizeof(sys_errlist[0]) - 1)
