/* $Id: alloc.c,v 1.10 2000/05/11 22:26:52 malekith Exp $ */

#include "h.h"

/* this memory gets free()ed every time line is read */
static void 	*mem, 		/* start of seg */
		*endmem,	/* end of brk()ed */
		*memptr;	/* logical end */

static int alloc_offset = 100000000;
#define ALLOC_JUMP 10000000

/* persistent memory -- this memory never gets free()ed */
struct allocator *a_pers, 
		 *a_arg,	/* used for arg expansion */
		 *a_state,	/* state stack */
		 *a_gl;		/* used by getline() to hold buffers */

#define CTX struct allocator

void a_push(CTX * ctx, const void *ptr, int size)
{
	void *d;
	d = a_alloc(ctx, size);
	memcpy(d, ptr, size);
}

void a_pop(CTX * ctx, void *ptr, int size)
{
	memcpy(ptr, (ctx->memptr -= size), size);
}

void a_push_state(CTX *ctx)
{
	if (ctx) {
		a_push_val(a_state, ctx->memptr);
		a_push_val(a_state, ctx->mem);
		a_align(ctx);
		ctx->mem = ctx->memptr;
	} else {
		a_push_val(a_state, memptr);
		a_push_val(a_state, mem);
		align();
		mem = memptr;
	}
}

void a_pop_state(CTX *ctx)
{
	if (ctx) {
		a_pop_val(a_state, ctx->mem);
		a_pop_val(a_state, ctx->memptr);
	} else {
		a_pop_val(a_state, mem);
		a_pop_val(a_state, memptr);
	}
}

void a_destroy(CTX *ctx)
{
	int fd;
	if (alloc_offset != ctx->ao) {
		perr("OOPS: alloc_offset != ctx->ao");
		abort();
	}
	fd = ctx->fd;
	munmap(ctx->mem, ctx->size);
	close(fd);
	alloc_offset -= ALLOC_JUMP;
}

CTX *a_create(void)
{
#define PROT_READ       0x1
#define PROT_WRITE      0x2
#define MAP_PRIVATE     0x02
#define MAP_FIXED       0x10
	int fd,psize;
	void *pmem;
	CTX *ctx;
	
	fd = hopen("/dev/zero", O_RDWR, 0);
	if (fd == -1) {
		perror("/dev/zero");
		exit(1);
	}
	pmem = (void*) (((unsigned long) mem + alloc_offset) & 0xffff0000);
	psize = 4096;
	pmem = mmap(pmem, psize, PROT_READ | PROT_WRITE, 
		    MAP_PRIVATE | MAP_FIXED, fd, 0);
	if (pmem == (void*)-1) {
		perror("mmap");
		exit(1);
	}
	ctx = (CTX*)pmem;
	
	ctx->mem = pmem;
	ctx->memptr = pmem + sizeof(CTX);
	ctx->endmem = pmem + psize;
	ctx->fd = fd;
	ctx->ao = alloc_offset;
	alloc_offset += ALLOC_JUMP;
	ctx->size = psize;
	a_align(ctx);

	return ctx;
}

void a_free(CTX *ctx)
{
	ctx->memptr = ctx->mem + sizeof(CTX);
}

void *a_alloc(CTX *ctx, int k)
{
	void *r;
	
	if (ctx->memptr + k > ctx->endmem) {
		int ns;
		
		ns = ctx->size + k + MEM_OFFSET;
		
		r = mremap(ctx->mem, ctx->size, ns, 0);
		if (r == (void*)-1) {
			perror("mremap(%d)", ns);
			exit(1);
		}
		ctx->size = ns;
		ctx->endmem = ctx->mem + ns;
	}
	
	r = ctx->memptr;
	ctx->memptr += k;
	
	return r;
}

void alloc_init()
{
	memptr = mem = brk(0);

	/* mmap some memory faaaaaaaaaaar away for non-deletable data */
	a_pers = a_create();
	/* and some for args */
	a_arg = a_create();
	/* and one more for state stack */
	a_state = a_create();
	a_gl = a_create();
}


void alloc_free()
{
	memptr = mem;
}

void *alloc(int k)
{
	void *r;
	
	if (memptr + k > endmem) {
		endmem = brk(memptr + k + MEM_OFFSET);

		if (memptr + k > endmem) {
			/* can't use printf here !!!! */
			if (script)
				eputs(script);
			else
				eputs(our_name);
			eputs(": out of memory\n");
			exit(1);
		}
	}
	
	r = memptr;
	memptr += k;
	
	return r;
}


#ifndef align
void align()
{
	alloc(MEM_ALIGN - ((unsigned long)memptr & (MEM_ALIGN - 1)));
}

void a_align(CTX *ctx)
{
	if (ctx)
		a_alloc(ctx, MEM_ALIGN - ((unsigned long)ctx->memptr & 
			(MEM_ALIGN - 1)));
	else
		align();
}
#endif

