#!/bin/awk -f

BEGIN {
	if (ARGC != 3) {
		print "Usage: tcp_wrappers2tcpd <hosts.allow> <hosts.deny>"
		exit 1
	}
	allow_file = ARGV[1]
	deny_file = ARGV[2]

while (getline < allow_file) {
# Remove comments and blank lines
    if (!/^#/ && !/^[ \t]*$/) {
	line = line " " $0
	if (/\\$/) {
		gsub(/\\$/," ",line)
		continue
	}
	split(line, service, ":")
	allowservice = service[1]
	denyservice = ""
	# Eat up blanks, convert multiple tabs/spaces/commas to one comma
	gsub(/(^[ \t]+|[ \t]+$)/, "", service[2])
	gsub(/[ \t]+/, ",", service[2])
	gsub(/,+/, ",", service[2])
	allowhosts = "," service[2]
	denyhosts = ""
	if (toupper(service[2]) ~ /EXCEPT/) {
		denyservice = allowservice
		allowhosts = ""
		n = split(service[2], ehosts, ",")
		for (i = 1 ; toupper(ehosts[i]) != "EXCEPT" ; i++) {
			allowhosts = allowhosts "," ehosts[i]
		}
		for (i++ ; i <= n ; i++) {
			denyhosts = denyhosts "," ehosts[i]
		}
	}
	gsub(/(^,+|,+$)/, "", allowhosts)
	gsub(/(^,+|,+$)/, "", denyhosts)
	if (toupper(service[1]) ~ /EXCEPT/) {
		n = split(service[1], newservice, " ")
		for (i = 3 ; i <= n ; i++) {
			gsub(/[ \t]/,"",newservice[i])
			if (length(newservice[i]) == 0) continue
			DHOSTS[newservice[i], allowhosts] = allowhosts
			DCOMMANDS[newservice[i], allowhosts] = service[3]
			DSERVICES[newservice[i], allowhosts] = newservice[i]
			AHOSTS[newservice[i], denyhosts] = denyhosts
			ACOMMANDS[newservice[i], denyhosts] = service[3]
			ASERVICES[newservice[i], denyhosts] = newservice[i]
		}
		allowservice = newservice[1]
		if (length(denyservice) > 0) denyservice = newservice[1]
	} 
	gsub(/[ \t]/,"",allowservice)
	gsub(/[ \t]/,"",denyservice)
	ASERVICES[allowservice, allowhosts] = allowservice
	ACOMMANDS[allowservice, allowhosts] = service[3]
	AHOSTS[allowservice, allowhosts] = allowhosts
	if (length(denyservice) > 0) {
		DSERVICES[denyservice, denyhosts] = denyservice
		DCOMMANDS[denyservice, denyhosts] = service[3]
		DHOSTS[denyservice, denyhosts] = denyhosts
	}
	line = ""
    }
}

while (getline < deny_file) {
# Remove comments and blank lines
    if (!/^#/ && !/^[ \t]*$/) {
	line = line " " $0
	if (/\\$/) {
		gsub(/\\$/," ",line)
		continue
	}
	split(line, service, ":")
	denyservice = service[1]
	allowservice = ""
	# Eat up blanks, convert multiple tabs/spaces/commas to one comma
	gsub(/(^[ \t]+|[ \t]+$)/, "", service[2])
	gsub(/[ \t]+/, ",", service[2])
	gsub(/,+/, ",", service[2])
	denyhosts = "," service[2]
	allowhosts = ""
	if (toupper(service[2]) ~ /EXCEPT/) {
		allowservice = denyservice
		denyhosts = ""
		n = split(service[2], ehosts, ",")
		for (i = 1 ; toupper(ehosts[i]) != "EXCEPT" ; i++) {
			denyhosts = denyhosts "," ehosts[i]
		}
		for (i++ ; i <= n ; i++) {
			allowhosts = allowhosts "," ehosts[i]
		}
	}
	gsub(/(^,+|,+$)/, "", allowhosts)
	gsub(/(^,+|,+$)/, "", denyhosts)
	if (toupper(service[1]) ~ /EXCEPT/) {
		n = split(service[1], newservice, " ")
		for (i = 3 ; i <= n ; i++) {
			gsub(/[ \t]/,"",newservice[i])
			if (length(newservice[i]) == 0) continue
			DHOSTS[newservice[i], allowhosts] = allowhosts
			DCOMMANDS[newservice[i], allowhosts] = service[3]
			DSERVICES[newservice[i], allowhosts] = newservice[i]
			AHOSTS[newservice[i], denyhosts] = denyhosts
			ACOMMANDS[newservice[i], denyhosts] = service[3]
			ASERVICES[newservice[i], denyhosts] = newservice[i]
		}
		denyservice = newservice[1]
		if (length(allowservice) > 0) allowservice = newservice[1]
	} 
	gsub(/[ \t]/,"",allowservice)
	gsub(/[ \t]/,"",denyservice)
	DSERVICES[denyservice, denyhosts] = denyservice
	DCOMMANDS[denyservice, denyhosts] = service[3]
	DHOSTS[denyservice, denyhosts] = denyhosts
	if (length(allowservice) > 0) {
		ASERVICES[allowservice, allowhosts] = allowservice
		ACOMMANDS[allowservice, allowhosts] = service[3]
		AHOSTS[allowservice, allowhosts] = allowhosts
	}
	line = ""
    }
}
}

END {
	for (i in ASERVICES) {
		ALLSERVICES[i] = ASERVICES[i]
	}
	for (i in DSERVICES) {
		ALLSERVICES[i] = DSERVICES[i]
	}
	for (i in ALLSERVICES) {
		s = ALLSERVICES[i]
		if (ADONE[s] == 1) continue
		print ALLSERVICES[i]
		for (j in AHOSTS) {
			if (ASERVICES[j] == s) {
				n = split(AHOSTS[j], A, ",")
				for (k = 1 ; k <= n ; k++) {
					output = "	ALLOW " A[k]
					if (length(ACOMMANDS[j]) > 0) {
						output = output " | | " ACOMMANDS[j]
					}
					print output
				}
			}
		}
		for (j in DHOSTS) {
			if (DSERVICES[j] == s) {
				n = split(DHOSTS[j], A, ",")
				for (k = 1 ; k <= n ; k++) {
					output = "	DENY " A[k]
					if (length(DCOMMANDS[j]) > 0) {
						output = output " | | " DCOMMANDS[j]
					}
					print output
				}
			}
		}
		ADONE[s] = 1;
	}
}
