/*
 * tcpd_check.c
 *
 * 		This program is free software; you can redistribute it and/or
 * 		modify it under the terms of the BSD style license (see
 * 		COPYING file included with this software).
 *
 * Authors:     Kazunori Fujiwara <fujiwara@rcac.tdi.co.jp>
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "rcsid.h"
RCSID(PKG_VER "$Id: tcpd_check.c,v 1.7 2001/10/17 14:11:54 wiget Exp $")

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

#include "tcpd.h"
#include "tcpd_local.h"

char *user = "";
char *src_fdqn = "";
char *src_addr = "";
char *service = "";
char *dst_fdqn = "";
char *dst_addr = "";
int ipv46 = AF_UNSPEC;
char *table = "/etc/hosts.access";

int main(int argc, char *argv[])
{
	int c;
	struct request_info *req;
	int ret;
	char str[TCPD_STRINGLENL];
	char *rets;

	while ((c = getopt(argc, argv, "46hs:S:d:D:u:U:a:")) != -1)
	switch(c) {
	case '4':
		ipv46 = AF_INET;
		break;
	case '6':
		ipv46 = AF_INET6;
		break;
	case 's':
		src_fdqn = strdup(optarg);
		break;
	case 'd':
		dst_fdqn = strdup(optarg);
		break;
	case 'S':
		src_addr = strdup(optarg);
		break;
	case 'D':
		dst_addr = strdup(optarg);
		break;
	case 'u':
		user = strdup(optarg);
		break;
	case 'U':
		service = strdup(optarg);
		break;
	case 'a':
		table = strdup(optarg);
		break;
	case 'h':
		printf("Usage: %s [-4] [-6] [-s src_fqdn] [-d dst_fqdn] [-S src_addr] [-D dst_addr] [-u user] [-U service] [-a table] [-h]\n",argv[0]);
		return (0);
		break;
	}
	req = request_init(RQ_FILE, 0, RQ_SETTABLE, table,
		RQ_DAEMON, service, RQ_USER, user,
		RQ_SERVER_NAME, dst_fdqn, RQ_CLIENT_NAME, src_fdqn,
		RQ_SERVER_ADDR, dst_addr, RQ_CLIENT_ADDR, src_addr,
		RQ_END);
	req->src.__ss_family = ipv46;
	req->dst.__ss_family = ipv46;

	ret = hosts_access(req);
	switch(ret) {
	case TCPD_ERROR: rets = "error"; break;
	case TCPD_ALLOW: rets = "allow"; break;
	case TCPD_DENY:  rets = "deny "; break;
	default:         rets = "xxxxx"; break;
	}
	tcpd_satostr(str, sizeof(str), &req->dst);
	printf("%s@%s[%s] ", req->service, req->dst_name, str);
	tcpd_satostr(str, sizeof(str), &req->src);
	printf("%s@%s[%s] ", req->user, req->src_name, str);

	printf("%s lineno=%d error=%d syslog=%03x/%03x command=[%s]\n",
			rets, req->lineno, req->error,
			allow_severity, deny_severity, req->commands);
	free_request(req);
	return (0);
}
