/*
 * rfc1413.c
 *
 * 		This program is free software; you can redistribute it and/or
 * 		modify it under the terms of the BSD style license (see
 * 		COPYING file included with this software).
 * 		
 * Authors:	Kazunori Fujiwara <fujiwara@rcac.tdi.co.jp>
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "rcsid.h"
RCSID("$Id: rfc1413.c,v 1.7 2001/10/17 10:22:54 wiget Exp $")

#include <stdio.h>
#include <setjmp.h>
#include <unistd.h>
#include <signal.h>
#include <netdb.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include "tcpd.h"
#include "tcpd_local.h"

#define IDENT_PORT "113"
#define	STRINGLEN  512

static int writes(int sock, char *buf)
{
	char *p;
	int i, len;

	p = buf;
	len = strlen(buf);

	while(len > 0) {
		if ((i = write(sock, p, len)) <= 0)
			return 0;
		len -= i;
		p += i;
	}
	return 1;
}

static int read1(int sock, char *buf, int len)
{
	char *p, *q;
	int i, left;

	p = buf;
	left = len - 1;
	while((i = read(sock, p, left)) > 0) {
		q = p;
		p += i;
		left -= i;
		*p = '\0';
		if (strchr(q, '\n') != NULL)
			break;
	}
	return i > 0;
}

static int timeout_happen;

static void timeout(int sig)
{
	timeout_happen = 1;
}

char *rfc1413(
	struct sockaddr_storage *local,
	struct sockaddr_storage *remote,
	char *user, int userlen, int rfc1413_timeout)
{
	int s, old_alarm;
	char *p, *ret = NULL;
	struct addrinfo hints, *rres, *lres;
	char buf[STRINGLEN];
	char buf2[STRINGLEN];
	char rhost[NI_MAXHOST], lhost[NI_MAXHOST];
	char rport[NI_MAXSERV], lport[NI_MAXSERV];
	char nrport[NI_MAXSERV], nlport[NI_MAXSERV];

	if (rfc1413_timeout <= 0)
		return NULL;

	user[0] = '\0';
	if (getnameinfo((struct sockaddr *)remote,
				SA_LEN((struct sockaddr *)remote),
				rhost, sizeof(rhost), rport, sizeof(rport),
				NI_NUMERICHOST|NI_NUMERICSERV))
		return NULL;
	if (getnameinfo((struct sockaddr *)local,
				SA_LEN((struct sockaddr *)local),
				lhost, sizeof(lhost), lport, sizeof(lport),
				NI_NUMERICHOST|NI_NUMERICSERV))
		return NULL;
	memset(&hints, 0, sizeof(hints));
	hints.ai_family = remote->__ss_family;
	hints.ai_socktype = SOCK_STREAM;
	hints.ai_flags = AI_PASSIVE|AI_NUMERICHOST;
	if (getaddrinfo(lhost, NULL, &hints, &lres))
		return NULL;
	hints.ai_flags = AI_NUMERICHOST;
	if (getaddrinfo(rhost, IDENT_PORT, &hints, &rres))
	{
		freeaddrinfo(lres);
		return NULL;
	}
	snprintf(buf, sizeof(buf), "%s,%s\r\n", rport, lport);
	if ((s = socket(rres->ai_family, SOCK_STREAM, 0)) < 0)
		return NULL;
	timeout_happen = 0;
	signal(SIGALRM, timeout);
	old_alarm = alarm(rfc1413_timeout);
	if (bind(s, lres->ai_addr, lres->ai_addrlen) == 0
		  && connect(s, rres->ai_addr, rres->ai_addrlen) >= 0
		  && writes(s, buf)
		  && read1(s, buf, sizeof(buf))
		  && sscanf(buf, "%s , %s : USERID :%*[^:]:%512s",
			nrport, nlport, buf2) == 3
		  && !strcmp(nlport, lport) && !strcmp(nrport, rport)) {
			if ((p = strchr(buf2, '\r')) != NULL)
				*p = '\0';
			strncpy(user, buf2, userlen);
			ret = user;
			
		}
	alarm(old_alarm);
	close(s);
	signal(SIGALRM, SIG_IGN);
	freeaddrinfo(lres);
	freeaddrinfo(rres);

	return ret;
}

