/*
 * clean_request.c
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the BSD style license (see
 *		COPYING file included with this software).
 *
 * Authors:	Kazunori Fujiwara <fujiwara@rcac.tdi.co.jp>
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "rcsid.h"
RCSID("$Id: clean_request.c,v 1.5 2001/10/17 14:11:54 wiget Exp $")

#include <stdio.h>
#include <unistd.h>
#include <stdarg.h>
#include <errno.h>
#include <ctype.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <syslog.h>

#include "tcpd.h"
#include "tcpd_local.h"

void clean_request(struct request_info *req)
{
	if (req->udp) {
		struct sockaddr_storage sa;
		int len = sizeof(sa);
		char buf[BUFSIZ];
		(void)recvfrom(req->sock, buf, sizeof(buf),
			       0, (struct sockaddr *)&sa, &len);
	}
}

void clean_exit(struct request_info *req)
{
	clean_request(req);
	if (!req->udp)
		sleep(req->refuse_wait);
	free_request(req);
	exit(0);
}

