/*
 * tcpd_local.h 
 *
 * 		$Id: tcpd_local.h,v 1.8 2001/10/17 10:22:52 wiget Exp $
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the BSD style license (see
 *		COPYING file included with this software).
 *
 * Authors:	Kazunori Fujiwara <fujiwara@rcac.tdi.co.jp>
 *
 */
				
#ifndef _TCPD_LOCAL_H_
#define _TCPD_LOCAL_H_	1

#include <sys/types.h>
#include <sys/socket.h>

#define	TCPD_HOSTNAMELEN	257
#define	TCPD_STRINGLEN		64
#define	TCPD_STRINGLENL		257

#define TCPD_BUFLEN	1025

#define	SEPARATOR	'|'
#define	SPACESKIP(strp)	{while(*(strp) == ' ' || *(strp) == '\t') (strp)++;}

#define	TCPD_CONTINUE	-2
#define	TCPD_MATCH	-3
#define	TCPD_NOMATCH	0
#define TCPD_OK		0
#define TCPD_NOERROR	0

#define	T_UINTEGER	1  /* set unsigned integer to variable */
#define	T_INTEGER	2  /* set unsigned integer to variable */
#define	T_SET1		3  /* set 1 to integer variable */
#define T_SET0		4  /* set 0 to integer variable */
#define	T_STR		5  /* set 1 string value */
#define	T_FUNC_STR1	6  /* exec function with string option 1 */
#define	T_FUNC_STR2	7  /* exec function with string option 2 */
#define	T_FUNC_UINT1	8  /* exec function with unsigned integer */
#define	T_FUNC_SET0	9  /* exec function with 0 as a parameter */
#define	T_FUNC_SET1	10 /* exec function with 1 as a parameter */

#ifndef SA_LEN
# if defined(HAVE_SA_LEN)
#  define	SA_len(sa)	((sa)->sa_len)
# else
#  define	SA_LEN(sa)	((sa)->sa_family == AF_INET6 ? sizeof(struct sockaddr_in6) \
				: sizeof(struct sockaddr_in))
# endif
#endif

struct request_info {
	int sock; /* socket or file descriptor */
	struct sockaddr_storage src;
	struct sockaddr_storage dst;
	char src_name[TCPD_HOSTNAMELEN];
	char dst_name[TCPD_HOSTNAMELEN];
	char service[TCPD_STRINGLEN];
	char user[TCPD_STRINGLEN];
	char src_wrongdns;
	char dst_wrongdns;
	char error;
	char udp;
	char userresolved;
	int lineno;
	int refuse_wait;
	int rfc1413_timeout;
	char commands_default[TCPD_STRINGLENL];	/* optional commands:default */
	char commands[TCPD_STRINGLENL];	/* optional commands */
};

struct _code {
	char *tag;
	int   type;
	void *ptr;
	int len;
};

/* tcpd_tools.c functions */
int tcpd_separator(char **p);
void tcpd_to_nextseparator(char **p);
int tcpd_is_separator(int c);
int tcpd_is_wordsep(int c);
int tcpd_word(char *str, const char *keyword, char **left);
int tcpd_word_ws(char *str, const char *keyword, char **left);
int tcpd_pstrcmp(char *str, const char *keyword, char **left);
int tcpd_get_token(char *str, char **left, char *buf, int buflen);
void prefixlen2mask(int prefixlen, unsigned char *dest, int size);
int tcpd_parse_options(char *p, char **left, struct _code *flags);
int tcpd_get_token2(char *str, char **left, char *buf, int buflen);
int tcpd_parse_syslog(char *str, char **left);
char *tcpd_lineno(struct request_info *req);
void tcpd_satostr(char *str, int len, struct sockaddr_storage *sa);
int tcpd_exec_option(struct request_info *req);
char *rfc1413(struct sockaddr_storage *local, struct sockaddr_storage *remote,  char *user, int userlen, int rfc1413_timeout);

#endif /* tcpd_local.h */
