/*
 * tcpd.h	Main header file.
 *
 * 		$Id: tcpd.h,v 1.11 2001/10/17 14:11:53 wiget Exp $
 * 
 * 		This program is free software; you can redistribute it and/or
 * 		modify it under the terms of the BSD style license (see
 * 		COPYING file included with this software).
 *
 * Authors:	Kazunori Fujiwara <fujiwara@rcac.tdi.co.jp>
 *
 */

#ifndef _TCPD_H_
#define _TCPD_H_	1

#define TCPD_DEFAULT_RFC1413_TIMEOUT	30

#define STRING_UNKNOWN  	"unknown"	/* lookup failed	*/
#define STRING_PARANOID 	"paranoid"	/* hostname conflict	*/

#define	RQ_END			0	/* */
#define	RQ_FILE			1	/* int: socket fd		*/
#define	RQ_DAEMON		2	/* char *: service name	*/
#define	RQ_USER			3	/* set user (for test)	*/
#define	RQ_SERVER_SIN		4	/* set server sockaddr	*/
#define	RQ_CLIENT_SIN		5	/* set client sockaddr	*/
#define	RQ_SERVER_ADDR		6	/* set server addr (string)	*/
#define	RQ_CLIENT_ADDR		7	/* set client addr (string)	*/
#define	RQ_SERVER_NAME		8	/* set server FDQN		*/
#define	RQ_CLIENT_NAME		9	/* set client FDQN		*/
#define RQ_SETTABLE		10	/* set another access table	*/

#define TCPD_ALLOW		1
#define TCPD_DENY		0
#define TCPD_ERROR		-1

struct request_info;

extern int allow_severity;
extern int deny_severity;

struct request_info *request_init(int cmd, ...);
struct request_info *request_set(struct request_info *, int cmd, ...);
int hosts_access(struct request_info *);
int hosts_ctl(char *daemon, char *client_name, char *client_addr, char *client_user);
void refuse(struct request_info *req);
void tcpd_refuse2(struct request_info *req);
void tcpd_allowlog(struct request_info *req);
void clean_exit(struct request_info *req);
void clean_request(struct request_info *req);
void free_request(struct request_info *req);

#endif /* tcpd.h */
