/*
 * tcpd.c
 *
 * 		This program is free software; you can redistribute it and/or
 * 		modify it under the terms of the BSD style license (see
 * 		COPYING file included with this software).
 * 
 * Authors:     Kazunori Fujiwara <fujiwara@rcac.tdi.co.jp>
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "rcsid.h"
RCSID(PKG_VER "$Id: tcpd.c,v 1.4 2000/02/28 12:48:25 misiek Exp $")

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <string.h>
#include <syslog.h>

#include "tcpd.h"
#include "tcpd_local.h"

#ifndef	FACILITY
#define	FACILITY	LOG_DAEMON
#endif /* FACILITY */

#ifndef REAL_DAEMON_DIR
#define REAL_DAEMON_DIR LIBEXECDIR
#endif /* REAL_DAEMON_DIR */

#ifndef DAEMON_UMASK
#define	DAEMON_UMASK 002
#endif /* DAEMON_UMASK */

int main(int argc, char *argv[])
{
	struct request_info req;
	char path[TCPD_STRINGLENL];
	int ret;
#ifdef DEBUG
	char str[TCPD_STRINGLENL];
	char *rets;
#endif

#ifdef DAEMON_UMASK
	umask(DAEMON_UMASK);
#endif /* DAEMON_UMASK */

	if (argv[0][0] == '/') {
		strcpy(path, argv[0]);
		argv[0] = strrchr(argv[0], '/') + 1;
	} else {
		snprintf(path, sizeof(path), "%s/%s", REAL_DAEMON_DIR, argv[0]);
	}

#ifdef LOG_MAIL
	(void) openlog(argv[0], LOG_PID, FACILITY);
#else /* LOG_MAIL / !LOG_MAIL */
	(void) openlog(argv[0], LOG_PID);
#endif /* !LOG_MAIL */

	request_init(&req, RQ_FILE, 0, RQ_DAEMON, argv[0], RQ_END);
	fromhost(&req);

	ret = hosts_access(&req);

#ifdef DEBUG
	switch(ret) {
	case TCPD_ERROR: rets = "error"; break;
	case TCPD_ALLOW: rets = "allow"; break;
	case TCPD_DENY:  rets = "deny "; break;
	default:         rets = "xxxxx"; break;
	}
	tcpd_satostr(str, sizeof(str), &req.dst);
	syslog(allow_severity, "%s@%s[%s] ", req.service, req.dst_name, str);
	tcpd_satostr(str, sizeof(str), &req.src);
	syslog(allow_severity, "%s@%s[%s] ", req.user, req.src_name, str);

	syslog(allow_severity, "%s lineno=%d error=%d syslog=%03x/%03x command=[%s]\n", rets, req.lineno, req.error, allow_severity, deny_severity, req.commands);
#endif /* DEBUG */
	
	if (!ret)
		refuse(&req);
	tcpd_allowlog(&req);
	if (tcpd_exec_option(&req) == TCPD_ERROR)
		tcpd_refuse2(&req);
	(void)execv(path, argv);
	syslog(allow_severity, "error: cannot execute %s: %m", path);
	closelog();
	clean_exit(&req);
	exit(0);
}
