/*
 * eval_client.c
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the BSD style license (see
 *		COPYING file included with this software).
 *		
 * Authors:     Kazunori Fujiwara <fujiwara@rcac.tdi.co.jp>
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "rcsid.h"
RCSID("$Id: eval_client.c,v 1.3 2000/02/24 15:07:39 misiek Exp $")

#include <stdio.h>
#include <unistd.h>
#include <stdarg.h>
#include <errno.h>
#include <ctype.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <syslog.h>

#include "tcpd.h"
#include "tcpd_local.h"

char *eval_client(struct request_info *req)
{
	static char buff[TCPD_STRINGLENL];
	char buff2[TCPD_STRINGLEN];

	tcpd_satostr(buff2, sizeof(buff2), &req->src);

	snprintf(buff, sizeof(buff), "%s%s%s[%s]",
		req->user, req->user[0] == '\0' ? "": "@",
		req->src_name, buff2);
	return buff;
}
