/*
 * parse_syslog.c
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the BSD style license (see
 *		COPYING file included with this software).
 *		
 * Authors:     Kazunori Fujiwara <fujiwara@rcac.tdi.co.jp>
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "rcsid.h"
RCSID("$Id: parse_syslog.c,v 1.2 2000/02/24 15:07:39 misiek Exp $")

#include <unistd.h>
#include <string.h>
#define SYSLOG_NAMES
#include <syslog.h>
#include <ctype.h>

/* 
   convert string like "local0.notice" to LOG_MAKEPRI value
*/

int tcpd_parse_syslog(char *str, char **left)
{
	CODE *c;
	int l;
	int m;

	if (left != NULL)
		*left = str;
	for (c = facilitynames; c->c_name != NULL; c++) {
		l = strlen(c->c_name);
		if (!strncasecmp(str, c->c_name, l) && str[l] == '.')
			break;
	}
	if (c->c_name == NULL)
		return -1;
	m = c->c_val;
	str += l + 1;
	for (c = prioritynames; c->c_name != NULL; c++) {
		l = strlen(c->c_name);
		if (!strncasecmp(str, c->c_name, l)
			&& !isalnum(str[l]))
			break;
	}
	if (c->c_name == NULL)
		return -1;

	if (left != NULL)
		*left = str+l;
	return m | c->c_val;
}

#ifdef DEBUG_parse_syslog
#include <stdio.h>

int main(int argc, char *argv[])
{
	int l;

	l = tcpd_parse_syslog(argv[1], NULL);

	printf("%02x %d.%d\n", l, l >> 3, l & 7);
}
#endif
