/*
 * tcpd_local.h 
 *
 * 		$Id: tcpd_local.h,v 1.4 2000/05/15 12:38:55 misiek Exp $
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the BSD style license (see
 *		COPYING file included with this software).
 *
 * Authors:	Kazunori Fujiwara <fujiwara@rcac.tdi.co.jp>
 *
 */
				
#ifndef _TCPD_LOCAL_H_
#define _TCPD_LOCAL_H_	1

#define TCPD_BUFLEN	1025

#define	SEPARATOR	'|'
#define	SPACESKIP(strp)	{while(*(strp) == ' ' || *(strp) == '\t') (strp)++;}

#define	TCPD_CONTINUE	-2
#define	TCPD_MATCH	-3
#define	TCPD_NOMATCH	0
#define TCPD_OK		0
#define TCPD_NOERROR	0

#define	T_UINTEGER	1  /* set unsigned integer to variable */
#define	T_INTEGER	2  /* set unsigned integer to variable */
#define	T_SET1		3  /* set 1 to integer variable */
#define T_SET0		4  /* set 0 to integer variable */
#define	T_STR		5  /* set 1 string value */
#define	T_FUNC_STR1	6  /* exec function with string option 1 */
#define	T_FUNC_STR2	7  /* exec function with string option 2 */
#define	T_FUNC_UINT1	8  /* exec function with unsigned integer */

#ifndef SA_LEN
#define SA_LEN(x)       ((x)->sa_len)
#endif

struct _code {
	char *tag;
	int   type;
	void *ptr;
	int len;
};

/* tcpd_tools.c functions */
int tcpd_separator(char **p);
void tcpd_to_nextseparator(char **p);
int tcpd_is_separator(int c);
int tcpd_is_wordsep(int c);
int tcpd_word(char *str, const char *keyword, char **left);
int tcpd_word_ws(char *str, const char *keyword, char **left);
int tcpd_pstrcmp(char *str, const char *keyword, char **left);
int tcpd_get_token(char *str, char **left, char *buf, int buflen);
void prefixlen2mask(int prefixlen, unsigned char *dest, int size);
int tcpd_parse_options(char *p, char **left, struct _code *flags);
int tcpd_get_token2(char *str, char **left, char *buf, int buflen);
int tcpd_parse_syslog(char *str, char **left);

#endif /* tcpd_local.h */
