/*
 * tcpd_satostr.c
 *
 * 		This program is free software; you can redistribute it and/or
 * 		modify it under the terms of the BSD style license (see
 * 		COPYING file included with this software).
 * 		
 * Authors:	Kazunori Fujiwara <fujiwara@rcac.tdi.co.jp>
 *
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "rcsid.h"
RCSID("$Id: tcpd_satostr.c,v 1.3 2000/02/24 15:07:39 misiek Exp $")

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <string.h>

#include "tcpd.h"

void tcpd_satostr(char *str, int len, struct sockaddr_storage *sa)
{
	if (getnameinfo((struct sockaddr *)sa, SA_LEN((struct sockaddr *)sa),
				str, len, NULL, 0, NI_NUMERICHOST))
		sprintf(str, "AF=%d", sa->__ss_family);
}

