/*
 * tcpd_exec.c
 *
 * 		This program is free software; you can redistribute it and/or
 * 		modify it under the terms of the BSD style license (see
 * 		COPYING file included with this software).
 *
 * Authors:	Kazunori Fujiwara <fujiwara@rcac.tdi.co.jp>
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "rcsid.h"
RCSID("$Id: tcpd_exec.c,v 1.3 2000/02/24 15:07:39 misiek Exp $")

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <ctype.h>
#include <grp.h>
#include <pwd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <syslog.h>
#include <signal.h>

#include "tcpd.h"
#include "tcpd_local.h"

/*
   int tcpd_exec_option(struct request_info *req)
      exec tcpd options from 'req'

	setenv ... immediately executed
	setuid ... after parsing
	exec, twist, spawn ... after parsing
 */

static int noexec = 0;
static struct request_info *sreq;

static int exec_uid(char *v)
{
	struct passwd *p; 
	if ((p = getpwnam(v)) == NULL) {
		syslog(deny_severity, "%m:getpwnam(%s)", v);
		return 0;
	}
	setuid(p->pw_uid);
	return 1;
}

static int exec_gid(char *v)
{
	struct group *g; 
	if ((g = getgrnam(v)) == NULL) {
		syslog(deny_severity, "%m:getgrnam(%s)", v);
		return 0;
	}
	setgid(g->gr_gid);
	return 1;
}

static int exec_umask(char *v)
{
	char *ss;
	if (!isdigit(*v))
		return 0;
	umask(strtol(v, &ss, 8));
	return 1;
}

static int exec_nice(char *v)
{
	char *ss;
	if (!isdigit(*v))
		return 0;
	nice(strtol(v, &ss, 8));
	return 1;
}

static int exec_setenv(char *var, char *arg)
{
	setenv(var, arg, 1);
	return 1;
}

static int exec_twist(char *str)
{
	if (str[0])
		(void) execl("/bin/sh", "sh", "-c", str, (char *) 0);
	syslog(allow_severity, "%m: error : twist %s", str);
	clean_exit(sreq);
	return 0; /* No Error */
}

static int exec_system(char *str)
{
	if (str[0])
		if (system(str) < 0)
			return 1;
	syslog(allow_severity, "%m: error : system %s", str);
	clean_exit(sreq);
	return 0; /* No Error */
}

static int exec_banner(char *str)
{
	char crlf[3] = "\r\n";
	write(sreq->sock, str, strlen(str));
	write(sreq->sock, crlf, 2);
	return 1; /* No Error */
}

static struct _code execoptions[] = {
	{ "stop", T_SET1, &noexec, },
	{ "twist", T_FUNC_STR1, exec_twist, },
	{ "system", T_FUNC_STR1, exec_system, },
	{ "banner", T_FUNC_STR1, exec_banner, },
	{ "group", T_FUNC_STR1, exec_gid, },
	{ "user", T_FUNC_STR1, exec_uid, },
	{ "umask", T_FUNC_STR1, exec_umask, },
	{ "nice", T_INTEGER, exec_nice },
	{ "setenv", T_FUNC_STR2, exec_setenv, },
	{ NULL, }
};


int tcpd_exec_option(struct request_info *req)
{
	char *str;

	sreq = req;

	if (tcpd_parse_options(req->commands_default, &str, execoptions) == TCPD_ERROR) {
	  strcpy(req->commands, str);
	  return TCPD_ERROR;
	}
	if (tcpd_parse_options(req->commands, &str, execoptions) == TCPD_ERROR) {
	  strcpy(req->commands, str);
	  return TCPD_ERROR;
	}
	if (noexec)
		clean_exit(req);
	return TCPD_OK;
}

void tcpd_refuse2(struct request_info *req)
{
	char s1[TCPD_STRINGLEN];
	char s2[TCPD_STRINGLEN];

	tcpd_satostr(s1, sizeof(s1), &req->src);
	tcpd_satostr(s2, sizeof(s2), &req->dst);

	syslog(deny_severity, "refused connect from %s%s%s[%s] to %s@%s[%s] at line %d : exec string error:%s",
		req->user, req->user[0] == '\0' ? "": "@",
		req->src_name, s1,
		req->service,
		req->dst_name, s2,
		req->lineno,
		req->commands);
	clean_exit(req);
}
