/*
 * tcpd_allowlog.c
 *
 * 		This program is free software; you can redistribute it and/or
 * 		modify it under the terms of the BSD style license (see
 * 		COPYING file included with this software).
 * 	
 * Authors:	Kazunori Fujiwara <fujiwara@rcac.tdi.co.jp>
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "rcsid.h"
RCSID("$Id: tcpd_allowlog.c,v 1.3 2000/02/24 15:07:39 misiek Exp $")

#include <stdio.h>
#include <unistd.h>
#include <stdarg.h>
#include <errno.h>
#include <ctype.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <syslog.h>

#include "tcpd.h"

void tcpd_allowlog(struct request_info *req)
{
	char s1[TCPD_STRINGLEN];
	char s2[TCPD_STRINGLEN];

	tcpd_satostr(s1, sizeof(s1), &req->src);
	tcpd_satostr(s2, sizeof(s2), &req->dst);

	syslog(allow_severity, "allowed connect from %s%s%s[%s] to %s@%s[%s] at line %d%s",
		req->user, req->user[0] == '\0' ? "": "@",
		req->src_name, s1,
		req->service,
		req->dst_name, s2,
		req->lineno,
		req->wrongdns ? " src/dst DNS wrong(fake?)" : "");
}
