#include <expat.h>

#define MAXDEPTH 100


#define START(NAME) void NAME##_start_handler(const XML_Char *name, const XML_Char **attr)
#define END(NAME) void NAME##_end_handler(const XML_Char *name)
#define DATA(NAME) void NAME##_data_handler(void *userdata, const XML_Char *s, int len)

typedef void (*StartHandler)(const XML_Char *name, const XML_Char **attr);
typedef void (*EndHandler)(const XML_Char *name);
/* typedef void (*DataHandler)(const XML_Char *s, int len); */
typedef XML_CharacterDataHandler DataHandler;

typedef struct {
  StartHandler starthandler;
  EndHandler   endhandler;
  DataHandler  datahandler;
} Handlers;

void find_handlers(const char *, Handlers *);
void wait_for_root_element_start(void *userdata, const XML_Char *name, const XML_Char **attr);
