<?php

require_once("AccessList.php");

/**
* Parses a text for protection tags and helps decrypting and encrypting these.
*/
class ProtectionParser
{
    var $mContent = array();
    var $mParams = array();
    var $mParsedText;
    var $mText;
    var $mEnc;

    /**
    * Constructor. Creates a new Parser. Does not automatically parse
    * the text. Call parseText afterwards.
    * @param t Text (String) or EditPage object to be parsed.
    * @param enc Encryption-object to use for encryption and decryption.
    */
    function ProtectionParser($t, &$enc)
    {
        $this->mEnc = $enc;
        if (strtolower(get_class($t)) == "editpage") {
            $text = $t->mArticle->getContent();
            $section = $this->getSection();
            if ($section > 0) {
                $art = new Article($t->mTitle);
                $art->getContent();
                $text = $art->mContent;
            }
            $this->mText = $text;
        }
        else {
            $this->mText = $t;
        }
    }

    /**
    * Reads currently displayed or edited section from request.
    * @return Current section or 0 if no section is beeing edited.
    */
    function getSection()
    {
        global $wgRequest;
        // section when editing
        $section = $wgRequest->getText('section');
        if (!$section) {
            // for preview and finish editing, section is in wpSection
            $section = $wgRequest->getText('wpSection');
            if (!$section) {
                $section = 0;
            }
        }
        return $section;
    }

    /**
    * Parses a text for protect-tags and stores the texts in member-fields.
    * The resulting array are mContent, mParams and mSections.
    */
    function parseText() {
        $this->mContent = array();
        $this->mParams = array();
       
        $this->mElements = array (PROTECT_TAG);
       $this->mParsedText = Parser::extractTagsAndParams(
               $this->mElements,
               $this->mText,
               $this->mContent );
        
        // decrypt all tags that are stored encrypted
        foreach($this->mContent as $key => $content)
        {
            $dec = $this->mEnc->decrypt($content[1]);
            if ($dec != "") {
                $this->mContent[$key][1] = $dec;
            }
        }
    }
    
    /**
    * Retrieves access-list of users and groups found in all tags
    * in the text supplied in constructor.
    * @return AccessList-object with users that have permissions for
    *           all tags.
    */
    function getAccessList()
    {
        $list = new AccessList();
        foreach ($this->mContent as $param) {
            $list->RestrictUsers($param[2]["users"]);
            $list->RestrictGroups($param[2]["groups"]);
        }
        return $list;
    }
    
    /**
    * Retrieves text of this object with all protect-tags beeing
    * decrypted before.
    * @return Text with decrypted tags.
    */
    function getDecrypted() {
        $text = $this->mParsedText;
        foreach ($this->mContent as $rand => $cnt) {
            $mTags = $cnt[0];
           foreach ($cnt[2] as $tag => $value) {
                $mTags .= " $tag=\"$value\"";
            }
            $text = str_replace($rand,
                "<" . $mTags . ">"
                    .$this->mEnc->decrypt($cnt[1])
                    ."</protect>",
                $text);
        }
        return $text;
    }
    
    /**
    * Checks if the currently edited page contains protect-tags
    * @return true if Page is protected.
    */
    function isProtected() {
        if (count($this->mContent) != 0) {
            return true;
        }
        return false;
    }
   
    /**
    * Retrieves text of this object with all protect-tags beeing
    * encrypted before.
    * @return Text with encrypted tags.
    */
    function getEncrypted($userName)
    {
        require_once("ProtectTag.php");
        $text = $this->mParsedText;
        foreach ($this->mContent as $rand => $cnt) {
            $access = new AccessList($cnt[2]["users"],
                                     $cnt[2]["groups"]);
            $access->AddUser($userName);
            
            $tag = new ProtectTag();
            $tag->setAccessList($access);
            $tag->setShow($cnt[2]["show"]);
            $tag->setErrorPage($cnt[2]["errorpage"]);
            
            $text = str_replace($rand,
                $tag->getStart()."\n"
                    .$this->mEnc->encrypt($cnt[1])."\n"
                    .$tag->getEnd(),
                $text);
        }
    
        return $text;
    }
}

?>
