<?php

require_once("AccessList.php");

/**
* Helper for modifying protect-tags.
* Initialise with setters and then call getStart() and getEnd().
* @todo Add getters and fromString-method.
*/
class ProtectTag
{
    var $mAccess = null;
    var $mShow = "";
    var $mErrorPage = "";
    
    var $mValidShow = array("warning", "crypt", "page", "none", "text");
    
    /**
    * Constructor. Creates default-tag.
    */
    function ProtectTag()
    {
        $this->setShow("warning");
        $this->setAccessList(new AccessList());
    }
    
    /**
    * Set access list for current tag
    * @param access AccessList-Object
    */
    function setAccessList($access)
    {
        $this->mAccess = $access;
    }
    
    /**
    * Sets parameter "show" and checks for allowed values.
    * @param show "show"-parameter
    */
    function setShow($show)
    {
        if (in_array($show, $this->mValidShow)) {
            $this->mShow = $show;
        }
    }
    
    /**
    * Sets parameter "errorpage".
    * @param page "errorpage"
    */
    function setErrorPage($page)
    {
        $this->mErrorPage = $page;
    }
    
    /**
    * Get formatted start-tag of this object. It contains only the
    * needed parameters.
    * @return String with start-tag
    */
    function getStart()
    {
        $tag = "<".PROTECT_TAG." ";
        if ($this->mShow != "") {
            $tag = $tag."show=\"".$this->mShow."\"";
        }
        
        if ($this->mErrorPage != "") {
            $tag = $tag." errorpage=\"".$this->mErrorPage."\"";
        }
    
        $tag = $tag
                ." "
                .$this->mAccess->getUsersParam()
                ." "
                .$this->mAccess->getGroupsParam()
                .">";
        return $tag;
    }
    
    /**
    * Gets the end-tag of this protect-tag.
    * @return String with end-tag
    */
    function getEnd()
    {
        return "</".PROTECT_TAG.">";
    }
}

?>
