<?php

require_once("AccessList.php");
require_once("Encryption.php");
require_once("ProtectionParser.php");

/**
* Handles showing, editing and saving articles that contain <protect>-tags.
*/
class ProtectPage {

    /**
    * Private fields.
    */
    var $mEnc = null;
    var $mAccess = null;
    var $mParser = null;
    var $mParser1 = null;
    var $mShow = "";
    
    /**
    * Constructor.
    */
    function ProtectPage(&$parser) {
        $this->mEnc = new Encryption();
        $this->mParser1 = $parser;
    }

    /**
    * Initialises showing a protected area.
    * @param params Parameters of tag.
    */
    function initShow($users, $groups, $show) {
        $this->mAccess = new AccessList($users, $groups);
        $this->mShow = $show;
    }
    
    /**
    * Checks if the user can read the current object.
    * @param user Current User-object.
    * @return true if user can read the text, false otherwise.
    */
    function hasAccess(&$user)
    {
        if ($this->mShow == "text") {
            return true;
        }
        return $this->mAccess->hasAccess($user);
    }

    /**
    * Encrypts all protected tags within a text-block and 
    * ensures a given username is listed in the list of
    * allowed users.
    * @param text Text to encrypt protect-tags in.
    * @param userName Name of user to ensure to be in permitted list
    *                   (usually current username)
    */
    function encryptTags(&$text, $userName) {
        $this->mParser = new ProtectionParser($text, $this->mEnc);
        $this->mParser->parseText();
        $text = $this->mParser->getEncrypted($userName);
    }
    
    /**
    * Initialises editing-process by parsing the editpage and getting
    * permissions.
    * @editpage EditPage object
    */
    function initEdit($editpage) {
        $this->mParser = new ProtectionParser($editpage, $this->mEnc);
        $this->mParser->parseText();
        $this->mAccess = $this->mParser->getAccessList();
    }

    /**
    * Returns decrypted text of editpage initilised with initEdit.
    * @return Decrypted text.
    */
    function decryptPage() {
        return $this->mParser->getDecrypted();
    }
    /*
     * From Cipe.php
     */
    function parseTag ($text) {
        $text = $this->mParser1->parse( $text,
                                        $this->mParser1->mTitle,
                                        $this->mParser1->mOptions,
                                        false, false );
        $text = $text->getText();
        $text = preg_replace ('~^<p>\s*~', '', $text );
        $text = preg_replace ('~\s*</p>\s*~', '', $text );
        $text = preg_replace ('~\n$~', '', $text );
        return ($text);
    }
}

?>
