<?php

define("PROTECT_TAG",	"protect");
define("VAR_USERS",	"{{{USERS}}}");
define("VAR_GROUPS",	"{{{GROUPS}}}");

require_once("PageProtection.i18n.php");

$wgExtensionFunctions[] = "wfPageProtection";

$wgExtensionCredits['parserhook'][] = array(
    'name' => 'ProtectPage',
    'author' => 'Fabian Schmitt (http://meta.wikimedia.org/wiki/User:Sirius_gd)',
    'version' => '1.3',
    'url' => 'http://meta.wikimedia.org/wiki/PageProtection' );

/**
* Extension-function. Registers parser, hook, messages.
*/
function wfPageProtection() {
    global $wgParser;

    global $wgMessageCache, $wgPageProtectionMessages;
    foreach( $wgPageProtectionMessages as $key => $value ) {
	$wgMessageCache->addMessages( $wgPageProtectionMessages[$key], $key );
    }

    $wgParser->setHook( PROTECT_TAG, "protectPage" );

    global $wgHooks;
    $wgHooks['AlternateEdit'][] = 'protectedEdit';
    $wgHooks['ArticleSave'][] = 'protectSave';
}

require_once("ProtectPage.php");
require_once("ErrorHandler.php");

/**
* Callback function for the hook to the protect-tag.
* @param text Text to be protected
* @param params Parameters supplied to the tag
* @param parser Global parser-object
* @return If current user is allowed to read the page, $text will be returned.
*         Otherwise,  an error-page will be returned.
*/
function protectPage( $text, $params, &$parser) {
    $parser->disableCache();

    global $wgUser;
    global $wgOut;
    
    $protect = new ProtectPage($parser);
    $protect->initShow($params["users"], $params["groups"], $params["show"]);
    
    if ($protect->hasAccess($wgUser)) {
        global $wgRequest;
        $text = $protect->mEnc->decrypt($text);
        $text = $protect->parseTag($text);
        return ($text);
    }
    
    $show = $params["show"];
    $page = null;
    if (isset($params["errorpage"])) {
        $page = $params["errorpage"];
    }
    
    $err = new ErrorHandler($protect->mAccess,
			    $protect,
                            $show,
                            $page);
    return $err->showError($text);
}

/**
* Callback function for the hook to ArticleSave. Encrypts the
* data between protect-tags and ensures the current user is in 
* list of permitted users.
*/
function protectSave(&$article, &$user, &$text, &$summary, &$minoredit, &$watchthis, &$sectionanchor) {
//    die($text);
    global $wgParser;
    $protect = new ProtectPage($wgParser);
    $protect->mParser = new ProtectionParser($text, $protect->mEnc);
    $protect->mParser->parseText();
    $protect->encryptTags($text, $user->getName());

    return true;
}

/**
* Callback-function for hook to 'AlternateEdit'. Checks if the current user
* is allowed to edit the current article / section and if so returns the
* current editpage-object.
* @param editpage EditPage-object
* @return editpage if user is allowed to edit the section, null otherwise.
*/
function protectedEdit($editpage) {
    global $wgUser, $wgParser;
    
    $protect = new ProtectPage($wgParser);
    $protect->initEdit($editpage);
   
    if (!$protect->mParser->isProtected() ) {
        return $editpage;
    }
    
    if ($protect->mAccess->hasAccess($wgUser) ) {
        $editpage->mArticle->mContent =  $protect->decryptPage();
        return true;
    } else {    
        $err = new ErrorHandler($protect->mAccess, $wgParser);
        return $err->stopEditing();
    }
    
    return false;
}

?>
