<?php

/**
* Provides showing errors for protection-extension.
*/
class ErrorHandler
{
    var $mShow;
    var $mPage;
    var $mAccess;
    var $mParser1;

    /**
    * Constructor.
    * @param accss AccessList-object for current protection-tag.
    * @param show Parameter for protect-tag with type of error.
    *                (warning, page, none, text, crypt)
    * @param page Optional name of page to display if show="page"
    */
    function ErrorHandler($access, &$parser, $show = "warning", $page = "")
    {
        $this->mShow = $show;
        $this->mPage = $page;
        $this->mAccess = $access;
        $this->mParser1 = $parser;
    }
    
    /**
    * Shows error-message. Is initialised with constructor.
    * @param text Optional encrypted text to show if show-parameter
    **              was crypt.
    */
    function showError($text = "") {
        if ($this->mShow == "crypt") {
            return $text;
        } else if ($this->mShow == "page" && $this->mPage != "") {
            return $this->getErrorPage();
        } else if ($this->mShow == "none") {
            return "";
        }
    
        return $this->getErrorMessage(true);
    }
        
    /**
    * Reads the error-message 'ProtectedSite' from the message-cache and
    * replaces
    * all {{{USERS}}} by a comma-separated list of allowed users and all
    * {{{GROUPS}}} by a comma-separated lsit of allowed groups.
    * @param parseWiki If true, the text will be parsed before returning.
    * @return Error-message.
    */
    function getErrorMessage($parseWiki = true) {
	global $wgSitename;

        $msg = wfMsg('ProtectedSite', $wgSitename, VAR_USERS, VAR_GROUPS);
        return $this->formatMessage($msg, $parseWiki);
    }
    
    /**
    * Replaces parameters {{{USERS}}} and {{{GROUPS}}} with the 
    * comma-separated users- and groups-list and optionally parses
    * the output for wiki-syntax.
    * @param msg Text to be parsed.
    * @param parseWiki If true, text will be parsed for wiki-syntax.
    */
    function formatMessage($msg, $parseWiki = true) {
        global $wgOut;
        
        $msg = str_replace(VAR_USERS, $this->mAccess->getUserList(), $msg);
        $msg = str_replace(VAR_GROUPS, $this->mAccess->getGroupList(), $msg);
    
        if ($parseWiki) {
            return ($this->mParser1->parseTag ($msg));
        } else {
            return $msg;
        }
    }
    
    /**
    * Retrieves error-page submitted in custronctur.
    * @return Text from Article pointed to in errorpage-parameter.
    */
    function getErrorPage() {
        $tit = Title::newFromText($this->mPage);
        $art = new Article($tit);
        return $this->formatMessage($art->getContent());
    }
    
    /**
    * Cancels the editing and prints error message.
    */
    function stopEditing() {
        global $wgOut;
	$wgOut->setPageTitle( wfMsg( 'ProtectedTitle' ) );
        $wgOut->setRobotpolicy( 'noindex,nofollow' );
        $wgOut->setArticleRelated( false );
        $wgOut->addWikiText( $this->formatMessage( wfMsg ( 'ProtectedSiteEditing',
							    $wgSiteName,
							    VAR_USERS, VAR_GROUPS),
                                                    false) );
        $wgOut->returnToMain( false );
    }
}

?>
