<?php

define("RSA_PEM_FILE",  $wgPEMfile);

require_once("PEAR.php");
require_once("Crypt/RSA.php");

/**
* Handles encryption.
*/
class Encryption{
    
    var $mKeypair;

    /**
    * Creates a new file holding PEM-string.
    */
    function createPemFile() 
    {
        $keypair = new Crypt_RSA_KeyPair(256);
        $str = $keypair->toPEMString();
        file_put_contents(RSA_PEM_FILE, $str);        
    }
    
    /**
    * Constructor. Ensures PEM-file exists and reads private
    * key from this file.
    */
    function Encryption()
    {
        if (!file_exists(RSA_PEM_FILE)) {        
            $this->createPemFile();
        }
        $this->mKeypair = new Crypt_RSA_KeyPair(0);
        $this->mKeypair = $this->mKeypair->fromPEMString(
                            file_get_contents(RSA_PEM_FILE));
    }
    
    /**
    * Decrypts an RSA-encrypted text.
    * @param text Encrypted text
    * @return Plaintext
    */
    function decrypt($text) {
        $rsa = new Crypt_RSA;
        $dec = $rsa->decrypt($text, $this->mKeypair->getPrivateKey());
        if ($dec == "") {
            return $text;
        }
        return $dec;
    }
    
    /**
    * Encrypts an text with RSA
    * @param text Plaintext
    * @return RSA-encrypted text.
    */
    function encrypt($text) {
        $rsa = new Crypt_RSA;
        return $rsa->encrypt($text, $this->mKeypair->getPublicKey());
    }
}
?>
