/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.jpa.config;

import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.catalog.jpa.config.DataSourceConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.EclipseLinkJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableJpaRepositories(value={"org.apache.logging.log4j.catalog.jpa.dao"})
@EnableTransactionManagement
@Profile(value={"eclipseLink"})
public class EclipseLinkConfig {
    private static Logger LOGGER = LogManager.getLogger(EclipseLinkConfig.class);
    @Autowired
    private DataSourceConfig dataSourceConfig;

    @Bean
    public EntityManagerFactory entityManagerFactory() {
        LOGGER.debug("Creating EclipseLink entity manager.");
        EclipseLinkJpaVendorAdapter vendorAdapter = new EclipseLinkJpaVendorAdapter();
        vendorAdapter.setGenerateDdl(false);
        LocalContainerEntityManagerFactoryBean factory = new LocalContainerEntityManagerFactoryBean();
        Properties properties = new Properties();
        properties.setProperty("eclipselink.weaving", "static");
        factory.setJpaProperties(properties);
        factory.setJpaVendorAdapter((JpaVendorAdapter)vendorAdapter);
        factory.setPackagesToScan(new String[]{"org.apache.logging.log4j.catalog"});
        factory.setDataSource(this.dataSourceConfig.dataSource());
        factory.afterPropertiesSet();
        return factory.getObject();
    }

    @Bean
    public PlatformTransactionManager transactionManager() {
        JpaTransactionManager txManager = new JpaTransactionManager();
        txManager.setEntityManagerFactory(this.entityManagerFactory());
        return txManager;
    }
}

