/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.http.impl;

import java.util.function.Function;
import org.apache.kyuubi.shade.io.vertx.core.Future;
import org.apache.kyuubi.shade.io.vertx.core.Handler;
import org.apache.kyuubi.shade.io.vertx.core.http.HttpClient;
import org.apache.kyuubi.shade.io.vertx.core.http.HttpClientBuilder;
import org.apache.kyuubi.shade.io.vertx.core.http.HttpClientOptions;
import org.apache.kyuubi.shade.io.vertx.core.http.HttpClientResponse;
import org.apache.kyuubi.shade.io.vertx.core.http.HttpConnection;
import org.apache.kyuubi.shade.io.vertx.core.http.PoolOptions;
import org.apache.kyuubi.shade.io.vertx.core.http.RequestOptions;
import org.apache.kyuubi.shade.io.vertx.core.http.impl.SharedHttpClient;
import org.apache.kyuubi.shade.io.vertx.core.impl.CloseFuture;
import org.apache.kyuubi.shade.io.vertx.core.impl.ContextInternal;
import org.apache.kyuubi.shade.io.vertx.core.impl.VertxInternal;

public class HttpClientBuilderImpl
implements HttpClientBuilder {
    private final VertxInternal vertx;
    private HttpClientOptions clientOptions;
    private PoolOptions poolOptions;
    private Handler<HttpConnection> connectHandler;
    private Function<HttpClientResponse, Future<RequestOptions>> redirectHandler;

    public HttpClientBuilderImpl(VertxInternal vertx) {
        this.vertx = vertx;
    }

    @Override
    public HttpClientBuilder with(HttpClientOptions options) {
        this.clientOptions = options;
        return this;
    }

    @Override
    public HttpClientBuilder with(PoolOptions options) {
        this.poolOptions = options;
        return this;
    }

    @Override
    public HttpClientBuilder withConnectHandler(Handler<HttpConnection> handler) {
        this.connectHandler = handler;
        return this;
    }

    @Override
    public HttpClientBuilder withRedirectHandler(Function<HttpClientResponse, Future<RequestOptions>> handler) {
        this.redirectHandler = handler;
        return this;
    }

    private CloseFuture resolveCloseFuture() {
        ContextInternal context = this.vertx.getContext();
        return context != null ? context.closeFuture() : this.vertx.closeFuture();
    }

    @Override
    public HttpClient build() {
        Function<HttpClientResponse, Future<RequestOptions>> redirectHandler;
        HttpClient client;
        HttpClientOptions co = this.clientOptions != null ? this.clientOptions : new HttpClientOptions();
        PoolOptions po = this.poolOptions != null ? this.poolOptions : new PoolOptions();
        CloseFuture closeFuture = new CloseFuture();
        if (co.isShared()) {
            client = this.vertx.createSharedClient("__vertx.shared.httpClients", co.getName(), closeFuture, cf -> this.vertx.createHttpPoolClient(co, po, (CloseFuture)cf));
            client = new SharedHttpClient(this.vertx, closeFuture, client);
        } else {
            client = this.vertx.createHttpPoolClient(co, po, closeFuture);
        }
        Handler<HttpConnection> connectHandler = this.connectHandler;
        if (connectHandler != null) {
            client.connectionHandler(connectHandler);
        }
        if ((redirectHandler = this.redirectHandler) != null) {
            client.redirectHandler(redirectHandler);
        }
        this.resolveCloseFuture().add(closeFuture);
        return client;
    }
}

