/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.etcd.jetcd.impl;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.kyuubi.shade.io.etcd.jetcd.ByteSequence;
import org.apache.kyuubi.shade.io.etcd.jetcd.Lock;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.lock.LockRequest;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.lock.LockResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.lock.UnlockRequest;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.lock.VertxLockGrpc;
import org.apache.kyuubi.shade.io.etcd.jetcd.impl.ClientConnectionManager;
import org.apache.kyuubi.shade.io.etcd.jetcd.impl.Impl;
import org.apache.kyuubi.shade.io.etcd.jetcd.lock.UnlockResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.support.Errors;
import org.apache.kyuubi.shade.io.etcd.jetcd.support.Util;

final class LockImpl
extends Impl
implements Lock {
    private final VertxLockGrpc.LockVertxStub stub;
    private final ByteSequence namespace;

    LockImpl(ClientConnectionManager connectionManager) {
        super(connectionManager);
        this.stub = connectionManager.newStub(VertxLockGrpc::newVertxStub);
        this.namespace = connectionManager.getNamespace();
    }

    @Override
    public CompletableFuture<org.apache.kyuubi.shade.io.etcd.jetcd.lock.LockResponse> lock(ByteSequence name, long leaseId) {
        Objects.requireNonNull(name);
        LockRequest request = LockRequest.newBuilder().setName(Util.prefixNamespace(name, this.namespace)).setLease(leaseId).build();
        return this.execute(() -> this.stub.lock(request), response -> new org.apache.kyuubi.shade.io.etcd.jetcd.lock.LockResponse((LockResponse)response, this.namespace), Errors::isRetryable);
    }

    @Override
    public CompletableFuture<UnlockResponse> unlock(ByteSequence lockKey) {
        Objects.requireNonNull(lockKey);
        UnlockRequest request = UnlockRequest.newBuilder().setKey(Util.prefixNamespace(lockKey, this.namespace)).build();
        return this.execute(() -> this.stub.unlock(request), UnlockResponse::new, Errors::isRetryable);
    }
}

