/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.flink;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.gateway.api.config.SqlGatewayServiceConfigOptions;
import org.apache.flink.table.gateway.service.context.DefaultContext;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.flink.FlinkEngineUtils$;
import org.apache.kyuubi.engine.flink.FlinkSQLEngine;
import org.apache.kyuubi.util.SignalRegister$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class FlinkSQLEngine$
implements Logging,
scala.Serializable {
    public static FlinkSQLEngine$ MODULE$;
    private final KyuubiConf kyuubiConf;
    private Option<FlinkSQLEngine> currentEngine;
    private final String user;
    private final CountDownLatch org$apache$kyuubi$engine$flink$FlinkSQLEngine$$countDownLatch;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    static {
        new FlinkSQLEngine$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public KyuubiConf kyuubiConf() {
        return this.kyuubiConf;
    }

    public Option<FlinkSQLEngine> currentEngine() {
        return this.currentEngine;
    }

    public void currentEngine_$eq(Option<FlinkSQLEngine> x$1) {
        this.currentEngine = x$1;
    }

    private String user() {
        return this.user;
    }

    public CountDownLatch org$apache$kyuubi$engine$flink$FlinkSQLEngine$$countDownLatch() {
        return this.org$apache$kyuubi$engine$flink$FlinkSQLEngine$$countDownLatch;
    }

    public void main(String[] args) {
        SignalRegister$.MODULE$.registerLogger(this.logger());
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Flink SQL engine classpath: ").append(System.getProperty("java.class.path")).toString());
        FlinkEngineUtils$.MODULE$.checkFlinkVersion();
        try {
            this.kyuubiConf().loadFileDefaults();
            Utils$.MODULE$.fromCommandLineArgs(args, this.kyuubiConf());
            String flinkConfDir = (String)package$.MODULE$.env().getOrElse((Object)"FLINK_CONF_DIR", (Function0 & Serializable & scala.Serializable)() -> {
                String flinkHome = (String)package$.MODULE$.env().getOrElse((Object)"FLINK_HOME", (Function0 & Serializable & scala.Serializable)() -> {
                    URL jarLoc = GlobalConfiguration.class.getProtectionDomain().getCodeSource().getLocation();
                    return new File(jarLoc.toURI()).getParentFile().getParent();
                });
                return ((Object)Paths.get(flinkHome, "conf")).toString();
            });
            Configuration flinkConf = GlobalConfiguration.loadConfiguration((String)flinkConfDir);
            scala.collection.immutable.Map flinkConfFromArgs = (scala.collection.immutable.Map)this.kyuubiConf().getAll().filterKeys((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("flink."))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    return new Tuple2((Object)new StringOps(Predef$.MODULE$.augmentString(k)).stripPrefix("flink."), (Object)v);
                }
                throw new MatchError((Object)tuple2);
            }, Map$.MODULE$.canBuildFrom());
            flinkConf.addAll(Configuration.fromMap((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)flinkConfFromArgs).asJava())));
            String executionTarget = flinkConf.getString(DeploymentOptions.TARGET);
            this.setDeploymentConf(executionTarget, flinkConf);
            this.kyuubiConf().setIfMissing(KyuubiConf$.MODULE$.FRONTEND_THRIFT_BINARY_BIND_PORT(), BoxesRunTime.boxToInteger((int)0));
            DefaultContext engineContext = FlinkEngineUtils$.MODULE$.getDefaultContext(args, flinkConf, flinkConfDir);
            this.startEngine(engineContext);
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Flink engine started");
            this.bootstrap(executionTarget);
            this.org$apache$kyuubi$engine$flink$FlinkSQLEngine$$countDownLatch().await();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                if (this.currentEngine().isDefined()) {
                    this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Fatal error occurs, thus stopping the engines", throwable3);
                    this.currentEngine().foreach((Function1 & Serializable & scala.Serializable)engine -> {
                        engine.stop();
                        return BoxedUnit.UNIT;
                    });
                }
            }
            if (throwable2 != null) {
                Throwable throwable4 = throwable2;
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Failed to create FlinkSQL Engine", throwable4);
            }
            throw throwable;
        }
    }

    public void startEngine(DefaultContext engineContext) {
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Starting Flink SQL engine with default configuration: ").append(engineContext.getFlinkConfig()).toString());
        this.currentEngine_$eq((Option<FlinkSQLEngine>)new Some((Object)new FlinkSQLEngine(engineContext)));
        this.currentEngine().foreach((Function1 & Serializable & scala.Serializable)engine -> {
            FlinkSQLEngine$.$anonfun$startEngine$2(engine);
            return BoxedUnit.UNIT;
        });
    }

    private void bootstrap(String executionTarget) {
        Configuration flinkConf = new Configuration();
        TableEnvironment tableEnv = TableEnvironment.create((Configuration)flinkConf);
        if ("yarn-application".equalsIgnoreCase(executionTarget)) {
            flinkConf.set(PipelineOptions.NAME, (Object)"kyuubi-bootstrap-sql");
            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Running bootstrap Flink SQL in application mode with flink conf: ").append(flinkConf).append(".").toString());
            tableEnv.executeSql("select 'kyuubi'").await();
        }
        ((IterableLike)this.kyuubiConf().get(KyuubiConf$.MODULE$.ENGINE_FLINK_INITIALIZE_SQL())).foreach((Function1 & Serializable & scala.Serializable)stmt -> {
            FlinkSQLEngine$.$anonfun$bootstrap$2(tableEnv, stmt);
            return BoxedUnit.UNIT;
        });
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Bootstrap SQL finished.");
    }

    private void setDeploymentConf(String executionTarget, Configuration flinkConf) {
        this.kyuubiConf().getOption("flink.app.name").foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            flinkConf.setString("kyuubi.engine.name", x$2);
            return BoxedUnit.UNIT;
        });
        this.kyuubiConf().getOption("kyuubi.session.user").foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            flinkConf.setString("kyuubi.session.user", x$3);
            return BoxedUnit.UNIT;
        });
        flinkConf.set(SqlGatewayServiceConfigOptions.SQL_GATEWAY_SESSION_IDLE_TIMEOUT, (Object)Duration.ofMillis(0L));
        String string = executionTarget;
        if ("yarn-per-job".equals(string) ? true : "yarn-application".equals(string)) {
            if (flinkConf.containsKey("high-availability.cluster-id")) {
                flinkConf.setString("yarn.application.id", (String)flinkConf.toMap().get("high-availability.cluster-id"));
                return;
            }
            return;
        }
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Skip setting deployment conf for execution target ").append(string).toString());
    }

    public FlinkSQLEngine apply(DefaultContext engineContext) {
        return new FlinkSQLEngine(engineContext);
    }

    public Option<DefaultContext> unapply(FlinkSQLEngine x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)x$0.engineContext());
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$startEngine$2(FlinkSQLEngine engine) {
        engine.initialize(MODULE$.kyuubiConf());
        engine.start();
        Utils$.MODULE$.addShutdownHook(() -> engine.stop(), Utils$.MODULE$.FLINK_ENGINE_SHUTDOWN_PRIORITY() + 1);
    }

    public static final /* synthetic */ void $anonfun$bootstrap$2(TableEnvironment tableEnv$1, String stmt) {
        tableEnv$1.executeSql(stmt).await();
    }

    private FlinkSQLEngine$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.kyuubiConf = new KyuubiConf(KyuubiConf$.MODULE$.apply$default$1());
        this.currentEngine = None$.MODULE$;
        this.user = Utils$.MODULE$.currentUser();
        this.org$apache$kyuubi$engine$flink$FlinkSQLEngine$$countDownLatch = new CountDownLatch(1);
    }
}

