/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.jdbc.dialect;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.engine.jdbc.dialect.JdbcDialect;
import org.apache.kyuubi.engine.jdbc.impala.ImpalaSchemaHelper;
import org.apache.kyuubi.engine.jdbc.impala.ImpalaTRowSetGenerator;
import org.apache.kyuubi.engine.jdbc.schema.JdbcTRowSetGenerator;
import org.apache.kyuubi.engine.jdbc.schema.SchemaHelper;
import org.apache.kyuubi.session.Session;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000114AAC\u0006\u00011!)Q\u0004\u0001C\u0001=!)\u0001\u0005\u0001C!C!)q\b\u0001C!\u0001\")q\n\u0001C!!\")a\u000b\u0001C!/\")1\f\u0001C!9\")Q\f\u0001C\u0005=\")Q\r\u0001C\u0005M\")\u0011\u000e\u0001C\u0005U\ni\u0011*\u001c9bY\u0006$\u0015.\u00197fGRT!\u0001D\u0007\u0002\u000f\u0011L\u0017\r\\3di*\u0011abD\u0001\u0005U\u0012\u00147M\u0003\u0002\u0011#\u00051QM\\4j]\u0016T!AE\n\u0002\r-LX/\u001e2j\u0015\t!R#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002-\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u0007\t\u00035mi\u0011aC\u0005\u00039-\u00111B\u00133cG\u0012K\u0017\r\\3di\u00061A(\u001b8jiz\"\u0012a\b\t\u00035\u0001\tabZ3u)\u0006\u0014G.Z:Rk\u0016\u0014\u0018\u0010F\u0003#_E\u001aT\u0007\u0005\u0002$Y9\u0011AE\u000b\t\u0003K!j\u0011A\n\u0006\u0003O]\ta\u0001\u0010:p_Rt$\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B\u0013A\u0002)sK\u0012,g-\u0003\u0002.]\t11\u000b\u001e:j]\u001eT!a\u000b\u0015\t\u000bA\u0012\u0001\u0019\u0001\u0012\u0002\u000f\r\fG/\u00197pO\")!G\u0001a\u0001E\u000511o\u00195f[\u0006DQ\u0001\u000e\u0002A\u0002\t\n\u0011\u0002^1cY\u0016t\u0015-\\3\t\u000bY\u0012\u0001\u0019A\u001c\u0002\u0015Q\f'\r\\3UsB,7\u000fE\u00029{\tj\u0011!\u000f\u0006\u0003um\nA!\u001e;jY*\tA(\u0001\u0003kCZ\f\u0017B\u0001 :\u0005\u0011a\u0015n\u001d;\u0002\u001f\u001d,GoQ8mk6t7/U;fef$bAI!I\u00152k\u0005\"\u0002\"\u0004\u0001\u0004\u0019\u0015aB:fgNLwN\u001c\t\u0003\t\u001ak\u0011!\u0012\u0006\u0003\u0005FI!aR#\u0003\u000fM+7o]5p]\")\u0011j\u0001a\u0001E\u0005Y1-\u0019;bY><g*Y7f\u0011\u0015Y5\u00011\u0001#\u0003)\u00198\r[3nC:\u000bW.\u001a\u0005\u0006i\r\u0001\rA\t\u0005\u0006\u001d\u000e\u0001\rAI\u0001\u000bG>dW/\u001c8OC6,\u0017aE4fiR\u0013vn^*fi\u001e+g.\u001a:bi>\u0014H#A)\u0011\u0005I#V\"A*\u000b\u0005Ij\u0011BA+T\u0005QQEMY2U%><8+\u001a;HK:,'/\u0019;pe\u0006yq-\u001a;TG\",W.\u0019%fYB,'\u000fF\u0001Y!\t\u0011\u0016,\u0003\u0002['\na1k\u00195f[\u0006DU\r\u001c9fe\u0006!a.Y7f)\u0005\u0011\u0013!C5t!\u0006$H/\u001a:o)\ty6\r\u0005\u0002aC6\t\u0001&\u0003\u0002cQ\t9!i\\8mK\u0006t\u0007\"\u00023\b\u0001\u0004\u0011\u0013!\u0002<bYV,\u0017!F5t/&dGmY1sIN+GOQ=LsV,(-\u001b\u000b\u0003?\u001eDQ\u0001\u001b\u0005A\u0002\t\nq\u0001]1ui\u0016\u0014h.A\u0007u_&k\u0007/\u00197b%\u0016<W\r\u001f\u000b\u0003E-DQ\u0001[\u0005A\u0002\t\u0002")
public class ImpalaDialect
extends JdbcDialect {
    @Override
    public String getTablesQuery(String catalog, String schema, String tableName, List<String> tableTypes) {
        if (this.isPattern(schema)) {
            throw KyuubiSQLException$.MODULE$.featureNotSupported("Pattern-like schema names not supported");
        }
        StringBuilder query = new StringBuilder("show tables ");
        Object object = StringUtils.isNotEmpty((CharSequence)schema) && !this.isWildcardSetByKyuubi(schema) ? query.append(new java.lang.StringBuilder(4).append("in ").append(schema).append(" ").toString()) : BoxedUnit.UNIT;
        Object object2 = StringUtils.isNotEmpty((CharSequence)tableName) ? query.append(new java.lang.StringBuilder(7).append("like '").append(this.toImpalaRegex(tableName)).append("'").toString()) : BoxedUnit.UNIT;
        return query.toString();
    }

    @Override
    public String getColumnsQuery(Session session, String catalogName, String schemaName, String tableName, String columnName) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw KyuubiSQLException$.MODULE$.apply("Table name should not be empty", KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        if (this.isPattern(schemaName)) {
            throw KyuubiSQLException$.MODULE$.featureNotSupported("Pattern-like schema names not supported");
        }
        if (this.isPattern(tableName)) {
            throw KyuubiSQLException$.MODULE$.featureNotSupported("Pattern-like table names not supported");
        }
        StringBuilder query = new StringBuilder("show column stats ");
        Object object = StringUtils.isNotEmpty((CharSequence)schemaName) && !this.isWildcardSetByKyuubi(schemaName) ? query.append(new java.lang.StringBuilder(1).append(schemaName).append(".").toString()) : BoxedUnit.UNIT;
        query.append(tableName);
        return query.toString();
    }

    @Override
    public JdbcTRowSetGenerator getTRowSetGenerator() {
        return new ImpalaTRowSetGenerator();
    }

    @Override
    public SchemaHelper getSchemaHelper() {
        return new ImpalaSchemaHelper();
    }

    @Override
    public String name() {
        return "impala";
    }

    private boolean isPattern(String value) {
        return value != null && !this.isWildcardSetByKyuubi(value) && value.contains("*");
    }

    private boolean isWildcardSetByKyuubi(String pattern) {
        String string = pattern;
        String string2 = "%";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private String toImpalaRegex(String pattern) {
        return pattern.replace("%", "*");
    }
}

