/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.internal.AbstractServerStream;
import io.grpc.internal.ReadableBuffer;
import io.grpc.internal.StatsTraceContext;
import io.grpc.internal.TransportTracer;
import io.grpc.internal.WritableBuffer;
import io.grpc.internal.WritableBufferAllocator;
import io.grpc.netty.CancelServerStreamCommand;
import io.grpc.netty.NettyReadableBuffer;
import io.grpc.netty.NettyServerHandler;
import io.grpc.netty.NettyWritableBuffer;
import io.grpc.netty.NettyWritableBufferAllocator;
import io.grpc.netty.SendGrpcFrameCommand;
import io.grpc.netty.SendResponseHeadersCommand;
import io.grpc.netty.StreamIdHolder;
import io.grpc.netty.Utils;
import io.grpc.netty.WriteQueue;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.concurrent.GenericFutureListener;
import io.perfmark.Link;
import io.perfmark.PerfMark;
import io.perfmark.Tag;
import io.perfmark.TaskCloseable;
import java.util.logging.Level;
import java.util.logging.Logger;

class NettyServerStream
extends AbstractServerStream {
    private static final Logger log = Logger.getLogger(NettyServerStream.class.getName());
    private final Sink sink = new Sink();
    private final TransportState state;
    private final WriteQueue writeQueue;
    private final Attributes attributes;
    private final String authority;
    private final TransportTracer transportTracer;
    private final int streamId;

    public NettyServerStream(Channel channel, TransportState state, Attributes transportAttrs, String authority, StatsTraceContext statsTraceCtx, TransportTracer transportTracer) {
        super((WritableBufferAllocator)new NettyWritableBufferAllocator(channel.alloc()), statsTraceCtx);
        this.state = (TransportState)Preconditions.checkNotNull((Object)state, (Object)"transportState");
        this.writeQueue = state.handler.getWriteQueue();
        this.attributes = (Attributes)Preconditions.checkNotNull((Object)transportAttrs);
        this.authority = authority;
        this.transportTracer = (TransportTracer)Preconditions.checkNotNull((Object)transportTracer, (Object)"transportTracer");
        this.streamId = this.transportState().id();
    }

    protected TransportState transportState() {
        return this.state;
    }

    protected Sink abstractServerStreamSink() {
        return this.sink;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public String getAuthority() {
        return this.authority;
    }

    public int streamId() {
        return this.streamId;
    }

    public static class TransportState
    extends AbstractServerStream.TransportState
    implements StreamIdHolder {
        private final Http2Stream http2Stream;
        private final NettyServerHandler handler;
        private final EventLoop eventLoop;
        private final Tag tag;

        public TransportState(NettyServerHandler handler, EventLoop eventLoop, Http2Stream http2Stream, int maxMessageSize, StatsTraceContext statsTraceCtx, TransportTracer transportTracer, String methodName) {
            super(maxMessageSize, statsTraceCtx, transportTracer);
            this.http2Stream = (Http2Stream)Preconditions.checkNotNull((Object)http2Stream, (Object)"http2Stream");
            this.handler = (NettyServerHandler)((Object)Preconditions.checkNotNull((Object)((Object)handler), (Object)"handler"));
            this.eventLoop = eventLoop;
            this.tag = PerfMark.createTag((String)methodName, (long)http2Stream.id());
        }

        public void runOnTransportThread(final Runnable r) {
            if (this.eventLoop.inEventLoop()) {
                r.run();
            } else {
                final Link link = PerfMark.linkOut();
                this.eventLoop.execute(new Runnable(){

                    @Override
                    public void run() {
                        try (TaskCloseable ignore = PerfMark.traceTask((String)"NettyServerStream$TransportState.runOnTransportThread");){
                            PerfMark.attachTag((Tag)tag);
                            PerfMark.linkIn((Link)link);
                            r.run();
                        }
                    }
                });
            }
        }

        public void bytesRead(int processedBytes) {
            this.handler.returnProcessedBytes(this.http2Stream, processedBytes);
            this.handler.getWriteQueue().scheduleFlush();
        }

        public void deframeFailed(Throwable cause) {
            log.log(Level.WARNING, "Exception processing message", cause);
            Status status = Status.fromThrowable((Throwable)cause);
            this.transportReportStatus(status);
            this.handler.getWriteQueue().enqueue(new CancelServerStreamCommand(this, status), true);
        }

        void inboundDataReceived(ByteBuf frame, boolean endOfStream) {
            super.inboundDataReceived((ReadableBuffer)new NettyReadableBuffer(frame.retain()), endOfStream);
        }

        @Override
        public int id() {
            return this.http2Stream.id();
        }

        @Override
        public Tag tag() {
            return this.tag;
        }
    }

    private class Sink
    implements AbstractServerStream.Sink {
        private Sink() {
        }

        public void writeHeaders(Metadata headers, boolean flush) {
            try (TaskCloseable ignore = PerfMark.traceTask((String)"NettyServerStream$Sink.writeHeaders");){
                NettyServerStream.this.writeQueue.enqueue(SendResponseHeadersCommand.createHeaders(NettyServerStream.this.transportState(), Utils.convertServerHeaders(headers)), flush);
            }
        }

        private void writeFrameInternal(WritableBuffer frame, boolean flush, final int numMessages) {
            Preconditions.checkArgument((numMessages >= 0 ? 1 : 0) != 0);
            ByteBuf bytebuf = ((NettyWritableBuffer)frame).bytebuf().touch();
            final int numBytes = bytebuf.readableBytes();
            NettyServerStream.this.onSendingBytes(numBytes);
            NettyServerStream.this.writeQueue.enqueue(new SendGrpcFrameCommand(NettyServerStream.this.transportState(), bytebuf, false), flush).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    NettyServerStream.this.transportState().onSentBytes(numBytes);
                    if (future.isSuccess()) {
                        NettyServerStream.this.transportTracer.reportMessageSent(numMessages);
                    }
                }
            });
        }

        public void writeFrame(WritableBuffer frame, boolean flush, int numMessages) {
            try (TaskCloseable ignore = PerfMark.traceTask((String)"NettyServerStream$Sink.writeFrame");){
                this.writeFrameInternal(frame, flush, numMessages);
            }
        }

        public void writeTrailers(Metadata trailers, boolean headersSent, Status status) {
            try (TaskCloseable ignore = PerfMark.traceTask((String)"NettyServerStream$Sink.writeTrailers");){
                Http2Headers http2Trailers = Utils.convertTrailers(trailers, headersSent);
                NettyServerStream.this.writeQueue.enqueue(SendResponseHeadersCommand.createTrailers(NettyServerStream.this.transportState(), http2Trailers, status), true);
            }
        }

        public void cancel(Status status) {
            try (TaskCloseable ignore = PerfMark.traceTask((String)"NettyServerStream$Sink.cancel");){
                NettyServerStream.this.writeQueue.enqueue(new CancelServerStreamCommand(NettyServerStream.this.transportState(), status), true);
            }
        }
    }
}

