/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.etcd.jetcd.api;

import org.apache.kyuubi.shade.io.etcd.jetcd.api.ClusterGrpc;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.MemberAddRequest;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.MemberAddResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.MemberListRequest;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.MemberListResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.MemberRemoveRequest;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.MemberRemoveResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.MemberUpdateRequest;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.MemberUpdateResponse;
import org.apache.kyuubi.shade.io.grpc.BindableService;
import org.apache.kyuubi.shade.io.grpc.CallOptions;
import org.apache.kyuubi.shade.io.grpc.Channel;
import org.apache.kyuubi.shade.io.grpc.ServerServiceDefinition;
import org.apache.kyuubi.shade.io.grpc.Status;
import org.apache.kyuubi.shade.io.grpc.StatusRuntimeException;
import org.apache.kyuubi.shade.io.grpc.stub.AbstractStub;
import org.apache.kyuubi.shade.io.grpc.stub.ServerCalls;
import org.apache.kyuubi.shade.io.grpc.stub.StreamObserver;
import org.apache.kyuubi.shade.io.vertx.core.Future;
import org.apache.kyuubi.shade.io.vertx.core.Vertx;
import org.apache.kyuubi.shade.io.vertx.core.impl.ContextInternal;
import org.apache.kyuubi.shade.io.vertx.grpc.stub.ClientCalls;
import org.apache.kyuubi.shade.io.vertx.grpc.stub.ServerCalls;

public final class VertxClusterGrpc {
    private static final int METHODID_MEMBER_ADD = 0;
    private static final int METHODID_MEMBER_REMOVE = 1;
    private static final int METHODID_MEMBER_UPDATE = 2;
    private static final int METHODID_MEMBER_LIST = 3;

    private VertxClusterGrpc() {
    }

    public static ClusterVertxStub newVertxStub(Channel channel) {
        return new ClusterVertxStub(channel);
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final ClusterVertxImplBase serviceImpl;
        private final int methodId;
        private final String compression;

        MethodHandlers(ClusterVertxImplBase serviceImpl, int methodId, String compression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.compression = compression;
        }

        @Override
        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    ServerCalls.oneToOne((MemberAddRequest)request, responseObserver, this.compression, this.serviceImpl::memberAdd);
                    break;
                }
                case 1: {
                    ServerCalls.oneToOne((MemberRemoveRequest)request, responseObserver, this.compression, this.serviceImpl::memberRemove);
                    break;
                }
                case 2: {
                    ServerCalls.oneToOne((MemberUpdateRequest)request, responseObserver, this.compression, this.serviceImpl::memberUpdate);
                    break;
                }
                case 3: {
                    ServerCalls.oneToOne((MemberListRequest)request, responseObserver, this.compression, this.serviceImpl::memberList);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        @Override
        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }
    }

    public static abstract class ClusterVertxImplBase
    implements BindableService {
        private String compression;

        public ClusterVertxImplBase withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        public Future<MemberAddResponse> memberAdd(MemberAddRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Future<MemberRemoveResponse> memberRemove(MemberRemoveRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Future<MemberUpdateResponse> memberUpdate(MemberUpdateRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Future<MemberListResponse> memberList(MemberListRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        @Override
        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder(ClusterGrpc.getServiceDescriptor()).addMethod(ClusterGrpc.getMemberAddMethod(), org.apache.kyuubi.shade.io.grpc.stub.ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0, this.compression))).addMethod(ClusterGrpc.getMemberRemoveMethod(), org.apache.kyuubi.shade.io.grpc.stub.ServerCalls.asyncUnaryCall(new MethodHandlers(this, 1, this.compression))).addMethod(ClusterGrpc.getMemberUpdateMethod(), org.apache.kyuubi.shade.io.grpc.stub.ServerCalls.asyncUnaryCall(new MethodHandlers(this, 2, this.compression))).addMethod(ClusterGrpc.getMemberListMethod(), org.apache.kyuubi.shade.io.grpc.stub.ServerCalls.asyncUnaryCall(new MethodHandlers(this, 3, this.compression))).build();
        }
    }

    public static final class ClusterVertxStub
    extends AbstractStub<ClusterVertxStub> {
        private final ContextInternal ctx;
        private ClusterGrpc.ClusterStub delegateStub;

        private ClusterVertxStub(Channel channel) {
            super(channel);
            this.delegateStub = ClusterGrpc.newStub(channel);
            this.ctx = (ContextInternal)Vertx.currentContext();
        }

        private ClusterVertxStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = ClusterGrpc.newStub(channel).build(channel, callOptions);
            this.ctx = (ContextInternal)Vertx.currentContext();
        }

        @Override
        protected ClusterVertxStub build(Channel channel, CallOptions callOptions) {
            return new ClusterVertxStub(channel, callOptions);
        }

        public Future<MemberAddResponse> memberAdd(MemberAddRequest request) {
            return ClientCalls.oneToOne(this.ctx, request, this.delegateStub::memberAdd);
        }

        public Future<MemberRemoveResponse> memberRemove(MemberRemoveRequest request) {
            return ClientCalls.oneToOne(this.ctx, request, this.delegateStub::memberRemove);
        }

        public Future<MemberUpdateResponse> memberUpdate(MemberUpdateRequest request) {
            return ClientCalls.oneToOne(this.ctx, request, this.delegateStub::memberUpdate);
        }

        public Future<MemberListResponse> memberList(MemberListRequest request) {
            return ClientCalls.oneToOne(this.ctx, request, this.delegateStub::memberList);
        }
    }
}

