/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class BooleanColumnStatsData
implements TBase<BooleanColumnStatsData, _Fields>,
Serializable,
Cloneable,
Comparable<BooleanColumnStatsData> {
    private static final TStruct STRUCT_DESC = new TStruct("BooleanColumnStatsData");
    private static final TField NUM_TRUES_FIELD_DESC = new TField("numTrues", 10, 1);
    private static final TField NUM_FALSES_FIELD_DESC = new TField("numFalses", 10, 2);
    private static final TField NUM_NULLS_FIELD_DESC = new TField("numNulls", 10, 3);
    private static final TField BIT_VECTORS_FIELD_DESC = new TField("bitVectors", 11, 4);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    private long numTrues;
    private long numFalses;
    private long numNulls;
    private ByteBuffer bitVectors;
    private static final int __NUMTRUES_ISSET_ID = 0;
    private static final int __NUMFALSES_ISSET_ID = 1;
    private static final int __NUMNULLS_ISSET_ID = 2;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public BooleanColumnStatsData() {
    }

    public BooleanColumnStatsData(long numTrues, long numFalses, long numNulls) {
        this();
        this.numTrues = numTrues;
        this.setNumTruesIsSet(true);
        this.numFalses = numFalses;
        this.setNumFalsesIsSet(true);
        this.numNulls = numNulls;
        this.setNumNullsIsSet(true);
    }

    public BooleanColumnStatsData(BooleanColumnStatsData other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.numTrues = other.numTrues;
        this.numFalses = other.numFalses;
        this.numNulls = other.numNulls;
        if (other.isSetBitVectors()) {
            this.bitVectors = TBaseHelper.copyBinary((ByteBuffer)other.bitVectors);
        }
    }

    public BooleanColumnStatsData deepCopy() {
        return new BooleanColumnStatsData(this);
    }

    public void clear() {
        this.setNumTruesIsSet(false);
        this.numTrues = 0L;
        this.setNumFalsesIsSet(false);
        this.numFalses = 0L;
        this.setNumNullsIsSet(false);
        this.numNulls = 0L;
        this.bitVectors = null;
    }

    public long getNumTrues() {
        return this.numTrues;
    }

    public void setNumTrues(long numTrues) {
        this.numTrues = numTrues;
        this.setNumTruesIsSet(true);
    }

    public void unsetNumTrues() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetNumTrues() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setNumTruesIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public long getNumFalses() {
        return this.numFalses;
    }

    public void setNumFalses(long numFalses) {
        this.numFalses = numFalses;
        this.setNumFalsesIsSet(true);
    }

    public void unsetNumFalses() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetNumFalses() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setNumFalsesIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public long getNumNulls() {
        return this.numNulls;
    }

    public void setNumNulls(long numNulls) {
        this.numNulls = numNulls;
        this.setNumNullsIsSet(true);
    }

    public void unsetNumNulls() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetNumNulls() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setNumNullsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public byte[] getBitVectors() {
        this.setBitVectors(TBaseHelper.rightSize((ByteBuffer)this.bitVectors));
        return this.bitVectors == null ? null : this.bitVectors.array();
    }

    public ByteBuffer bufferForBitVectors() {
        return TBaseHelper.copyBinary((ByteBuffer)this.bitVectors);
    }

    public void setBitVectors(byte[] bitVectors) {
        this.bitVectors = bitVectors == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(bitVectors, bitVectors.length));
    }

    public void setBitVectors(ByteBuffer bitVectors) {
        this.bitVectors = TBaseHelper.copyBinary((ByteBuffer)bitVectors);
    }

    public void unsetBitVectors() {
        this.bitVectors = null;
    }

    public boolean isSetBitVectors() {
        return this.bitVectors != null;
    }

    public void setBitVectorsIsSet(boolean value) {
        if (!value) {
            this.bitVectors = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case NUM_TRUES: {
                if (value == null) {
                    this.unsetNumTrues();
                    break;
                }
                this.setNumTrues((Long)value);
                break;
            }
            case NUM_FALSES: {
                if (value == null) {
                    this.unsetNumFalses();
                    break;
                }
                this.setNumFalses((Long)value);
                break;
            }
            case NUM_NULLS: {
                if (value == null) {
                    this.unsetNumNulls();
                    break;
                }
                this.setNumNulls((Long)value);
                break;
            }
            case BIT_VECTORS: {
                if (value == null) {
                    this.unsetBitVectors();
                    break;
                }
                this.setBitVectors((ByteBuffer)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case NUM_TRUES: {
                return this.getNumTrues();
            }
            case NUM_FALSES: {
                return this.getNumFalses();
            }
            case NUM_NULLS: {
                return this.getNumNulls();
            }
            case BIT_VECTORS: {
                return this.getBitVectors();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case NUM_TRUES: {
                return this.isSetNumTrues();
            }
            case NUM_FALSES: {
                return this.isSetNumFalses();
            }
            case NUM_NULLS: {
                return this.isSetNumNulls();
            }
            case BIT_VECTORS: {
                return this.isSetBitVectors();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof BooleanColumnStatsData) {
            return this.equals((BooleanColumnStatsData)that);
        }
        return false;
    }

    public boolean equals(BooleanColumnStatsData that) {
        if (that == null) {
            return false;
        }
        boolean this_present_numTrues = true;
        boolean that_present_numTrues = true;
        if (this_present_numTrues || that_present_numTrues) {
            if (!this_present_numTrues || !that_present_numTrues) {
                return false;
            }
            if (this.numTrues != that.numTrues) {
                return false;
            }
        }
        boolean this_present_numFalses = true;
        boolean that_present_numFalses = true;
        if (this_present_numFalses || that_present_numFalses) {
            if (!this_present_numFalses || !that_present_numFalses) {
                return false;
            }
            if (this.numFalses != that.numFalses) {
                return false;
            }
        }
        boolean this_present_numNulls = true;
        boolean that_present_numNulls = true;
        if (this_present_numNulls || that_present_numNulls) {
            if (!this_present_numNulls || !that_present_numNulls) {
                return false;
            }
            if (this.numNulls != that.numNulls) {
                return false;
            }
        }
        boolean this_present_bitVectors = this.isSetBitVectors();
        boolean that_present_bitVectors = that.isSetBitVectors();
        if (this_present_bitVectors || that_present_bitVectors) {
            if (!this_present_bitVectors || !that_present_bitVectors) {
                return false;
            }
            if (!this.bitVectors.equals(that.bitVectors)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Comparable<Boolean>> list = new ArrayList<Comparable<Boolean>>();
        boolean present_numTrues = true;
        list.add(Boolean.valueOf(present_numTrues));
        if (present_numTrues) {
            list.add(Long.valueOf(this.numTrues));
        }
        boolean present_numFalses = true;
        list.add(Boolean.valueOf(present_numFalses));
        if (present_numFalses) {
            list.add(Long.valueOf(this.numFalses));
        }
        boolean present_numNulls = true;
        list.add(Boolean.valueOf(present_numNulls));
        if (present_numNulls) {
            list.add(Long.valueOf(this.numNulls));
        }
        boolean present_bitVectors = this.isSetBitVectors();
        list.add(Boolean.valueOf(present_bitVectors));
        if (present_bitVectors) {
            list.add(this.bitVectors);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(BooleanColumnStatsData other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetNumTrues()).compareTo(other.isSetNumTrues());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNumTrues() && (lastComparison = TBaseHelper.compareTo((long)this.numTrues, (long)other.numTrues)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetNumFalses()).compareTo(other.isSetNumFalses());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNumFalses() && (lastComparison = TBaseHelper.compareTo((long)this.numFalses, (long)other.numFalses)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetNumNulls()).compareTo(other.isSetNumNulls());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNumNulls() && (lastComparison = TBaseHelper.compareTo((long)this.numNulls, (long)other.numNulls)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetBitVectors()).compareTo(other.isSetBitVectors());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBitVectors() && (lastComparison = TBaseHelper.compareTo((Comparable)this.bitVectors, (Comparable)other.bitVectors)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BooleanColumnStatsData(");
        boolean first = true;
        sb.append("numTrues:");
        sb.append(this.numTrues);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("numFalses:");
        sb.append(this.numFalses);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("numNulls:");
        sb.append(this.numNulls);
        first = false;
        if (this.isSetBitVectors()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("bitVectors:");
            if (this.bitVectors == null) {
                sb.append("null");
            } else {
                TBaseHelper.toString((ByteBuffer)this.bitVectors, (StringBuilder)sb);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetNumTrues()) {
            throw new TProtocolException("Required field 'numTrues' is unset! Struct:" + this.toString());
        }
        if (!this.isSetNumFalses()) {
            throw new TProtocolException("Required field 'numFalses' is unset! Struct:" + this.toString());
        }
        if (!this.isSetNumNulls()) {
            throw new TProtocolException("Required field 'numNulls' is unset! Struct:" + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new BooleanColumnStatsDataStandardSchemeFactory());
        schemes.put(TupleScheme.class, new BooleanColumnStatsDataTupleSchemeFactory());
        optionals = new _Fields[]{_Fields.BIT_VECTORS};
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.NUM_TRUES, new FieldMetaData("numTrues", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.NUM_FALSES, new FieldMetaData("numFalses", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.NUM_NULLS, new FieldMetaData("numNulls", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.BIT_VECTORS, new FieldMetaData("bitVectors", 2, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(BooleanColumnStatsData.class, metaDataMap);
    }

    private static class BooleanColumnStatsDataTupleScheme
    extends TupleScheme<BooleanColumnStatsData> {
        private BooleanColumnStatsDataTupleScheme() {
        }

        public void write(TProtocol prot, BooleanColumnStatsData struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI64(struct.numTrues);
            oprot.writeI64(struct.numFalses);
            oprot.writeI64(struct.numNulls);
            BitSet optionals = new BitSet();
            if (struct.isSetBitVectors()) {
                optionals.set(0);
            }
            oprot.writeBitSet(optionals, 1);
            if (struct.isSetBitVectors()) {
                oprot.writeBinary(struct.bitVectors);
            }
        }

        public void read(TProtocol prot, BooleanColumnStatsData struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.numTrues = iprot.readI64();
            struct.setNumTruesIsSet(true);
            struct.numFalses = iprot.readI64();
            struct.setNumFalsesIsSet(true);
            struct.numNulls = iprot.readI64();
            struct.setNumNullsIsSet(true);
            BitSet incoming = iprot.readBitSet(1);
            if (incoming.get(0)) {
                struct.bitVectors = iprot.readBinary();
                struct.setBitVectorsIsSet(true);
            }
        }
    }

    private static class BooleanColumnStatsDataTupleSchemeFactory
    implements SchemeFactory {
        private BooleanColumnStatsDataTupleSchemeFactory() {
        }

        public BooleanColumnStatsDataTupleScheme getScheme() {
            return new BooleanColumnStatsDataTupleScheme();
        }
    }

    private static class BooleanColumnStatsDataStandardScheme
    extends StandardScheme<BooleanColumnStatsData> {
        private BooleanColumnStatsDataStandardScheme() {
        }

        public void read(TProtocol iprot, BooleanColumnStatsData struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 10) {
                            struct.numTrues = iprot.readI64();
                            struct.setNumTruesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 10) {
                            struct.numFalses = iprot.readI64();
                            struct.setNumFalsesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 10) {
                            struct.numNulls = iprot.readI64();
                            struct.setNumNullsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 11) {
                            struct.bitVectors = iprot.readBinary();
                            struct.setBitVectorsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, BooleanColumnStatsData struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(NUM_TRUES_FIELD_DESC);
            oprot.writeI64(struct.numTrues);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(NUM_FALSES_FIELD_DESC);
            oprot.writeI64(struct.numFalses);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(NUM_NULLS_FIELD_DESC);
            oprot.writeI64(struct.numNulls);
            oprot.writeFieldEnd();
            if (struct.bitVectors != null && struct.isSetBitVectors()) {
                oprot.writeFieldBegin(BIT_VECTORS_FIELD_DESC);
                oprot.writeBinary(struct.bitVectors);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class BooleanColumnStatsDataStandardSchemeFactory
    implements SchemeFactory {
        private BooleanColumnStatsDataStandardSchemeFactory() {
        }

        public BooleanColumnStatsDataStandardScheme getScheme() {
            return new BooleanColumnStatsDataStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        NUM_TRUES(1, "numTrues"),
        NUM_FALSES(2, "numFalses"),
        NUM_NULLS(3, "numNulls"),
        BIT_VECTORS(4, "bitVectors");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return NUM_TRUES;
                }
                case 2: {
                    return NUM_FALSES;
                }
                case 3: {
                    return NUM_NULLS;
                }
                case 4: {
                    return BIT_VECTORS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

