/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.zookeeper;

import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.file.Paths;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.service.AbstractService;
import org.apache.kyuubi.service.ServiceState$;
import org.apache.kyuubi.shaded.zookeeper.server.NIOServerCnxnFactory;
import org.apache.kyuubi.shaded.zookeeper.server.ZooKeeperServer;
import org.apache.kyuubi.zookeeper.ZookeeperConf$;
import scala.Enumeration;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001\u0002\r\u001a\u0001\tBQ!\u000b\u0001\u0005\u0002)B\u0011\"\f\u0001A\u0002\u0003\u0007I\u0011\u0002\u0018\t\u0013a\u0002\u0001\u0019!a\u0001\n\u0013I\u0004\"\u0003\"\u0001\u0001\u0004\u0005\t\u0015)\u00030\u0011%\u0019\u0005\u00011AA\u0002\u0013%A\tC\u0005I\u0001\u0001\u0007\t\u0019!C\u0005\u0013\"I1\n\u0001a\u0001\u0002\u0003\u0006K!\u0012\u0005\n\u0019\u0002\u0001\r\u00111A\u0005\n5C\u0011B\u0016\u0001A\u0002\u0003\u0007I\u0011B,\t\u0013e\u0003\u0001\u0019!A!B\u0013q\u0005\"\u0003.\u0001\u0001\u0004\u0005\r\u0011\"\u0003N\u0011%Y\u0006\u00011AA\u0002\u0013%A\fC\u0005_\u0001\u0001\u0007\t\u0011)Q\u0005\u001d\"9q\f\u0001b\u0001\n\u0013\u0001\u0007B\u00023\u0001A\u0003%\u0011\rC\u0005f\u0001\u0001\u0007\t\u0019!C\u0005M\"I!\u000f\u0001a\u0001\u0002\u0004%Ia\u001d\u0005\nk\u0002\u0001\r\u0011!Q!\n\u001dDQA\u001e\u0001\u0005B]Dq!!\u0001\u0001\t\u0003\n\u0019\u0001C\u0004\u0002\u0006\u0001!\t%a\u0001\t\r\u0005\u001d\u0001\u0001\"\u0001g\u0011\u001d\tI\u0001\u0001C\u0001\u0003\u0017\u0011\u0011#R7cK\u0012$W\r\u001a.p_.,W\r]3s\u0015\tQ2$A\u0005{_>\\W-\u001a9fe*\u0011A$H\u0001\u0007Wf,XOY5\u000b\u0005yy\u0012AB1qC\u000eDWMC\u0001!\u0003\ry'oZ\u0002\u0001'\t\u00011\u0005\u0005\u0002%O5\tQE\u0003\u0002'7\u000591/\u001a:wS\u000e,\u0017B\u0001\u0015&\u0005=\t%m\u001d;sC\u000e$8+\u001a:wS\u000e,\u0017A\u0002\u001fj]&$h\bF\u0001,!\ta\u0003!D\u0001\u001a\u0003\rQ8n]\u000b\u0002_A\u0011\u0001GN\u0007\u0002c)\u0011!gM\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005i!$BA\u001b\u001c\u0003\u0019\u0019\b.\u00193fI&\u0011q'\r\u0002\u00105>|7*Z3qKJ\u001cVM\u001d<fe\u00069!p[:`I\u0015\fHC\u0001\u001eA!\tYd(D\u0001=\u0015\u0005i\u0014!B:dC2\f\u0017BA =\u0005\u0011)f.\u001b;\t\u000f\u0005\u001b\u0011\u0011!a\u0001_\u0005\u0019\u0001\u0010J\u0019\u0002\ti\\7\u000fI\u0001\u000eg\u0016\u0014h/\u001a:GC\u000e$xN]=\u0016\u0003\u0015\u0003\"\u0001\r$\n\u0005\u001d\u000b$\u0001\u0006(J\u001fN+'O^3s\u0007:DhNR1di>\u0014\u00180A\ttKJ4XM\u001d$bGR|'/_0%KF$\"A\u000f&\t\u000f\u00053\u0011\u0011!a\u0001\u000b\u0006q1/\u001a:wKJ4\u0015m\u0019;pef\u0004\u0013!\u00043bi\u0006$\u0015N]3di>\u0014\u00180F\u0001O!\tyE+D\u0001Q\u0015\t\t&+\u0001\u0002j_*\t1+\u0001\u0003kCZ\f\u0017BA+Q\u0005\u00111\u0015\u000e\\3\u0002#\u0011\fG/\u0019#je\u0016\u001cGo\u001c:z?\u0012*\u0017\u000f\u0006\u0002;1\"9\u0011)CA\u0001\u0002\u0004q\u0015A\u00043bi\u0006$\u0015N]3di>\u0014\u0018\u0010I\u0001\u0011I\u0006$\u0018\rT8h\t&\u0014Xm\u0019;pef\fA\u0003Z1uC2{w\rR5sK\u000e$xN]=`I\u0015\fHC\u0001\u001e^\u0011\u001d\tE\"!AA\u00029\u000b\u0011\u0003Z1uC2{w\rR5sK\u000e$xN]=!\u0003i!W\r\\3uK\u0012\u000bG/\u0019#je\u0016\u001cGo\u001c:z\u001f:\u001cEn\\:f+\u0005\t\u0007CA\u001ec\u0013\t\u0019GHA\u0004C_>dW-\u00198\u00027\u0011,G.\u001a;f\t\u0006$\u0018\rR5sK\u000e$xN]=P]\u000ecwn]3!\u0003\u0011Awn\u001d;\u0016\u0003\u001d\u0004\"\u0001[8\u000f\u0005%l\u0007C\u00016=\u001b\u0005Y'B\u00017\"\u0003\u0019a$o\\8u}%\u0011a\u000eP\u0001\u0007!J,G-\u001a4\n\u0005A\f(AB*ue&twM\u0003\u0002oy\u0005A\u0001n\\:u?\u0012*\u0017\u000f\u0006\u0002;i\"9\u0011)EA\u0001\u0002\u00049\u0017!\u00025pgR\u0004\u0013AC5oSRL\u0017\r\\5{KR\u0011!\b\u001f\u0005\u0006sN\u0001\rA_\u0001\u0005G>tg\r\u0005\u0002|}6\tAP\u0003\u0002~7\u000511m\u001c8gS\u001eL!a ?\u0003\u0015-KX/\u001e2j\u0007>tg-A\u0003ti\u0006\u0014H\u000fF\u0001;\u0003\u0011\u0019Ho\u001c9\u0002!\u001d,GoQ8o]\u0016\u001cGo\u0015;sS:<\u0017!\u0006:fg>dg/\u001a)bi\"LeMU3mCRLg/\u001a\u000b\u0006\u001d\u00065\u0011q\u0002\u0005\u0006s^\u0001\rA\u001f\u0005\b\u0003#9\u0002\u0019AA\n\u0003-\u0019wN\u001c4jO\u0016sGO]=\u0011\tm\f)bZ\u0005\u0004\u0003/a(aC\"p]\u001aLw-\u00128uef\u0004")
public class EmbeddedZookeeper
extends AbstractService {
    private ZooKeeperServer zks;
    private NIOServerCnxnFactory serverFactory;
    private File dataDirectory;
    private File dataLogDirectory;
    private final boolean deleteDataDirectoryOnClose;
    private String host;

    private ZooKeeperServer zks() {
        return this.zks;
    }

    private void zks_$eq(ZooKeeperServer x$1) {
        this.zks = x$1;
    }

    private NIOServerCnxnFactory serverFactory() {
        return this.serverFactory;
    }

    private void serverFactory_$eq(NIOServerCnxnFactory x$1) {
        this.serverFactory = x$1;
    }

    private File dataDirectory() {
        return this.dataDirectory;
    }

    private void dataDirectory_$eq(File x$1) {
        this.dataDirectory = x$1;
    }

    private File dataLogDirectory() {
        return this.dataLogDirectory;
    }

    private void dataLogDirectory_$eq(File x$1) {
        this.dataLogDirectory = x$1;
    }

    private boolean deleteDataDirectoryOnClose() {
        return this.deleteDataDirectoryOnClose;
    }

    private String host() {
        return this.host;
    }

    private void host_$eq(String x$1) {
        this.host = x$1;
    }

    public synchronized void initialize(KyuubiConf conf) {
        this.dataDirectory_$eq(this.resolvePathIfRelative(conf, ZookeeperConf$.MODULE$.ZK_DATA_DIR()));
        this.dataLogDirectory_$eq(this.resolvePathIfRelative(conf, ZookeeperConf$.MODULE$.ZK_DATA_LOG_DIR()));
        int clientPort = BoxesRunTime.unboxToInt((Object)conf.get(ZookeeperConf$.MODULE$.ZK_CLIENT_PORT()));
        int tickTime = BoxesRunTime.unboxToInt((Object)conf.get(ZookeeperConf$.MODULE$.ZK_TICK_TIME()));
        int maxClientCnxns = BoxesRunTime.unboxToInt((Object)conf.get(ZookeeperConf$.MODULE$.ZK_MAX_CLIENT_CONNECTIONS()));
        int minSessionTimeout = BoxesRunTime.unboxToInt((Object)conf.get(ZookeeperConf$.MODULE$.ZK_MIN_SESSION_TIMEOUT()));
        int maxSessionTimeout = BoxesRunTime.unboxToInt((Object)conf.get(ZookeeperConf$.MODULE$.ZK_MAX_SESSION_TIMEOUT()));
        this.host_$eq((String)((Option)conf.get(ZookeeperConf$.MODULE$.ZK_CLIENT_PORT_ADDRESS())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            if (BoxesRunTime.unboxToBoolean((Object)conf.get(ZookeeperConf$.MODULE$.ZK_CLIENT_USE_HOSTNAME()))) {
                return Utils$.MODULE$.findLocalInetAddress().getCanonicalHostName();
            }
            return Utils$.MODULE$.findLocalInetAddress().getHostAddress();
        }));
        try {
            this.zks_$eq(new ZooKeeperServer(this.dataDirectory(), this.dataLogDirectory(), tickTime));
            this.zks().setMinSessionTimeout(minSessionTimeout);
            this.zks().setMaxSessionTimeout(maxSessionTimeout);
            this.serverFactory_$eq(new NIOServerCnxnFactory());
            this.serverFactory().configure(new InetSocketAddress(this.host(), clientPort), maxClientCnxns);
            super.initialize(conf);
        }
        catch (Exception e) {
            throw new RuntimeException(new StringBuilder(64).append("Failed to initialize the embedded ZooKeeper server, binding to ").append(this.host()).append(":").append(clientPort).toString(), e);
        }
    }

    public synchronized void start() {
        this.serverFactory().startup(this.zks());
        this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append(this.getName()).append(" is started at ").append(this.getConnectString()).toString());
        Utils$.MODULE$.addShutdownHook(() -> this.stop(), Utils$.MODULE$.SERVER_SHUTDOWN_PRIORITY() - 1);
        super.start();
    }

    public synchronized void stop() {
        Object object;
        Enumeration.Value value = this.getServiceState();
        Enumeration.Value value2 = ServiceState$.MODULE$.STARTED();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            if (this.serverFactory() != null) {
                this.serverFactory().shutdown();
            }
            if (this.zks() != null) {
                this.zks().shutdown();
            }
            if (this.deleteDataDirectoryOnClose()) {
                Utils$.MODULE$.deleteDirectoryRecursively(this.dataDirectory());
                object = BoxesRunTime.boxToBoolean((boolean)Utils$.MODULE$.deleteDirectoryRecursively(this.dataLogDirectory()));
            } else {
                object = BoxedUnit.UNIT;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        super.stop();
    }

    public synchronized String getConnectString() {
        Predef$.MODULE$.assert(this.zks() != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(7).append(this.getName()).append(" is in ").append(this.getServiceState()).toString());
        return new StringBuilder(1).append(this.host()).append(":").append(this.serverFactory().getLocalPort()).toString();
    }

    public File resolvePathIfRelative(KyuubiConf conf, ConfigEntry<String> configEntry) {
        String dirFromConfig = (String)conf.get(configEntry);
        return Paths.get((String)package$.MODULE$.env().getOrElse((Object)"KYUUBI_HOME", (Function0 & Serializable & scala.Serializable)() -> "."), new String[0]).resolve(dirFromConfig).toFile();
    }

    public EmbeddedZookeeper() {
        super("EmbeddedZookeeper");
        this.deleteDataDirectoryOnClose = true;
    }
}

