/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.net.jodah.failsafe.internal;

import java.util.BitSet;
import org.apache.kyuubi.shade.net.jodah.failsafe.internal.CircuitStats;

class CountingCircuitStats
implements CircuitStats {
    final BitSet bitSet;
    private final int size;
    volatile int currentIndex;
    private volatile int occupiedBits;
    private volatile int successes;
    private volatile int failures;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountingCircuitStats(int size, CircuitStats oldStats) {
        this.bitSet = new BitSet(size);
        this.size = size;
        if (oldStats != null) {
            CircuitStats circuitStats = oldStats;
            synchronized (circuitStats) {
                this.copyStats(oldStats);
            }
        }
    }

    void copyStats(CircuitStats oldStats) {
        if (oldStats instanceof CountingCircuitStats) {
            CountingCircuitStats old = (CountingCircuitStats)oldStats;
            int bitsToCopy = Math.min(old.occupiedBits, this.size);
            int oldIndex = old.currentIndex - bitsToCopy;
            if (oldIndex < 0) {
                oldIndex += old.occupiedBits;
            }
            for (int i = 0; i < bitsToCopy; ++i) {
                this.setNext(old.bitSet.get(oldIndex));
                oldIndex = old.indexAfter(oldIndex);
            }
        } else {
            this.copyExecutions(oldStats);
        }
    }

    @Override
    public void recordSuccess() {
        this.setNext(true);
    }

    @Override
    public void recordFailure() {
        this.setNext(false);
    }

    @Override
    public int getExecutionCount() {
        return this.occupiedBits;
    }

    @Override
    public int getFailureCount() {
        return this.failures;
    }

    @Override
    public synchronized int getFailureRate() {
        return (int)Math.round(this.occupiedBits == 0 ? 0.0 : (double)this.failures / (double)this.occupiedBits * 100.0);
    }

    @Override
    public int getSuccessCount() {
        return this.successes;
    }

    @Override
    public synchronized int getSuccessRate() {
        return (int)Math.round(this.occupiedBits == 0 ? 0.0 : (double)this.successes / (double)this.occupiedBits * 100.0);
    }

    synchronized int setNext(boolean value) {
        int previousValue = -1;
        if (this.occupiedBits < this.size) {
            ++this.occupiedBits;
        } else {
            previousValue = this.bitSet.get(this.currentIndex) ? 1 : 0;
        }
        this.bitSet.set(this.currentIndex, value);
        this.currentIndex = this.indexAfter(this.currentIndex);
        if (value) {
            if (previousValue != 1) {
                ++this.successes;
            }
            if (previousValue == 0) {
                --this.failures;
            }
        } else {
            if (previousValue != 0) {
                ++this.failures;
            }
            if (previousValue == 1) {
                --this.successes;
            }
        }
        return previousValue;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append('[');
        for (int i = 0; i < this.occupiedBits; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.bitSet.get(i));
        }
        return sb.append(']').toString();
    }

    private int indexAfter(int index) {
        return index == this.size - 1 ? 0 : index + 1;
    }
}

