/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.net;

import org.apache.kyuubi.shade.io.netty.handler.ssl.OpenSsl;
import org.apache.kyuubi.shade.io.vertx.codegen.annotations.DataObject;
import org.apache.kyuubi.shade.io.vertx.core.json.JsonObject;
import org.apache.kyuubi.shade.io.vertx.core.net.OpenSSLEngineOptionsConverter;
import org.apache.kyuubi.shade.io.vertx.core.net.SSLEngineOptions;

@DataObject(generateConverter=true, publicConverter=false)
public class OpenSSLEngineOptions
extends SSLEngineOptions {
    public static final boolean DEFAULT_SESSION_CACHE_ENABLED = true;
    private boolean sessionCacheEnabled;

    public static boolean isAvailable() {
        return OpenSsl.isAvailable();
    }

    public static boolean isAlpnAvailable() {
        return OpenSsl.isAlpnSupported();
    }

    public OpenSSLEngineOptions() {
        this.sessionCacheEnabled = true;
    }

    public OpenSSLEngineOptions(JsonObject json) {
        OpenSSLEngineOptionsConverter.fromJson(json, this);
    }

    public OpenSSLEngineOptions(OpenSSLEngineOptions other) {
        this.sessionCacheEnabled = other.isSessionCacheEnabled();
    }

    public OpenSSLEngineOptions setSessionCacheEnabled(boolean sessionCacheEnabled) {
        this.sessionCacheEnabled = sessionCacheEnabled;
        return this;
    }

    public boolean isSessionCacheEnabled() {
        return this.sessionCacheEnabled;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        OpenSSLEngineOptionsConverter.toJson(this, json);
        return json;
    }

    @Override
    public OpenSSLEngineOptions copy() {
        return new OpenSSLEngineOptions(this);
    }
}

