/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.net;

import java.util.Base64;
import java.util.Map;
import org.apache.kyuubi.shade.io.vertx.core.buffer.Buffer;
import org.apache.kyuubi.shade.io.vertx.core.json.JsonObject;
import org.apache.kyuubi.shade.io.vertx.core.json.impl.JsonUtil;
import org.apache.kyuubi.shade.io.vertx.core.net.JksOptions;

public class JksOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, JksOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "alias": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setAlias((String)member.getValue());
                    break;
                }
                case "aliasPassword": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setAliasPassword((String)member.getValue());
                    break;
                }
                case "password": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPassword((String)member.getValue());
                    break;
                }
                case "path": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPath((String)member.getValue());
                    break;
                }
                case "value": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setValue(Buffer.buffer(BASE64_DECODER.decode((String)member.getValue())));
                }
            }
        }
    }

    public static void toJson(JksOptions obj, JsonObject json) {
        JksOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(JksOptions obj, Map<String, Object> json) {
        if (obj.getAlias() != null) {
            json.put("alias", obj.getAlias());
        }
        if (obj.getAliasPassword() != null) {
            json.put("aliasPassword", obj.getAliasPassword());
        }
        if (obj.getPassword() != null) {
            json.put("password", obj.getPassword());
        }
        if (obj.getPath() != null) {
            json.put("path", obj.getPath());
        }
        if (obj.getValue() != null) {
            json.put("value", BASE64_ENCODER.encodeToString(obj.getValue().getBytes()));
        }
    }
}

