/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.grpc.netty;

import java.net.SocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import org.apache.kyuubi.shade.com.google.common.base.Preconditions;
import org.apache.kyuubi.shade.io.grpc.Internal;
import org.apache.kyuubi.shade.io.grpc.NameResolver;
import org.apache.kyuubi.shade.io.grpc.NameResolverProvider;
import org.apache.kyuubi.shade.io.grpc.netty.UdsNameResolver;
import org.apache.kyuubi.shade.io.netty.channel.unix.DomainSocketAddress;

@Internal
public final class UdsNameResolverProvider
extends NameResolverProvider {
    private static final String SCHEME = "unix";

    @Override
    public UdsNameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        if (SCHEME.equals(targetUri.getScheme())) {
            return new UdsNameResolver(targetUri.getAuthority(), UdsNameResolverProvider.getTargetPathFromUri(targetUri));
        }
        return null;
    }

    static String getTargetPathFromUri(URI targetUri) {
        Preconditions.checkArgument(SCHEME.equals(targetUri.getScheme()), "scheme must be unix");
        String targetPath = targetUri.getPath();
        if (targetPath == null) {
            targetPath = Preconditions.checkNotNull(targetUri.getSchemeSpecificPart(), "targetPath");
        }
        return targetPath;
    }

    @Override
    public String getDefaultScheme() {
        return SCHEME;
    }

    @Override
    protected boolean isAvailable() {
        return true;
    }

    @Override
    protected int priority() {
        return 3;
    }

    @Override
    protected Collection<Class<? extends SocketAddress>> getProducedSocketAddressTypes() {
        return Collections.singleton(DomainSocketAddress.class);
    }
}

