/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.MaybeSource;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.operators.maybe.MaybeMap;
import io.reactivex.internal.operators.maybe.MaybeZipArray;
import java.util.Arrays;

public final class MaybeZipIterable<T, R>
extends Maybe<R> {
    final Iterable<? extends MaybeSource<? extends T>> sources;
    final Function<? super Object[], ? extends R> zipper;

    public MaybeZipIterable(Iterable<? extends MaybeSource<? extends T>> sources, Function<? super Object[], ? extends R> zipper) {
        this.sources = sources;
        this.zipper = zipper;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void subscribeActual(MaybeObserver<? super R> observer) {
        void var5_8;
        MaybeSource[] a = new MaybeSource[8];
        int n = 0;
        try {
            for (MaybeSource<? extends T> maybeSource : this.sources) {
                if (n == a.length) {
                    a = Arrays.copyOf(a, n + (n >> 2));
                }
                a[n++] = maybeSource;
            }
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            EmptyDisposable.error(ex, observer);
            return;
        }
        if (n == 0) {
            EmptyDisposable.complete(observer);
            return;
        }
        if (n == 1) {
            a[0].subscribe(new MaybeMap.MapMaybeObserver(observer, new Function<T, R>(){

                @Override
                public R apply(T t) throws Exception {
                    return MaybeZipIterable.this.zipper.apply((Object[])new Object[]{t});
                }
            }));
            return;
        }
        MaybeZipArray.ZipCoordinator parent = new MaybeZipArray.ZipCoordinator(observer, n, this.zipper);
        observer.onSubscribe(parent);
        boolean bl = false;
        while (var5_8 < n) {
            if (parent.isDisposed()) {
                return;
            }
            a[var5_8].subscribe(parent.observers[var5_8]);
            ++var5_8;
        }
    }
}

