/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.mysql;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hive.service.rpc.thrift.TFetchResultsResp;
import org.apache.hive.service.rpc.thrift.TGetResultSetMetadataResp;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.hive.service.rpc.thrift.TRowSet;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.operation.FetchOrientation$;
import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.operation.OperationState$;
import org.apache.kyuubi.operation.OperationStatus;
import org.apache.kyuubi.server.mysql.MySQLComInitDbPacket;
import org.apache.kyuubi.server.mysql.MySQLComPingPacket;
import org.apache.kyuubi.server.mysql.MySQLComQueryPacket;
import org.apache.kyuubi.server.mysql.MySQLComQuitPacket;
import org.apache.kyuubi.server.mysql.MySQLCommandHandler$;
import org.apache.kyuubi.server.mysql.MySQLCommandPacket;
import org.apache.kyuubi.server.mysql.MySQLDialectHelper$;
import org.apache.kyuubi.server.mysql.MySQLErrPacket;
import org.apache.kyuubi.server.mysql.MySQLErrPacket$;
import org.apache.kyuubi.server.mysql.MySQLOKPacket;
import org.apache.kyuubi.server.mysql.MySQLOKPacket$;
import org.apache.kyuubi.server.mysql.MySQLPacket;
import org.apache.kyuubi.server.mysql.MySQLQueryResult;
import org.apache.kyuubi.server.mysql.MySQLQueryResult$;
import org.apache.kyuubi.server.mysql.MySQLThriftQueryResult;
import org.apache.kyuubi.server.mysql.constant.MySQLCtxAttrKey$;
import org.apache.kyuubi.service.BackendService;
import org.apache.kyuubi.session.SessionHandle;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u00055x!\u0002\u0010 \u0011\u0003Qc!\u0002\u0017 \u0011\u0003i\u0003\"\u0002\u001b\u0002\t\u0003)\u0004b\u0002\u001c\u0002\u0005\u0004%\ta\u000e\u0005\u0007\t\u0006\u0001\u000b\u0011\u0002\u001d\t\u000f\u0015\u000b!\u0019!C\u0001\r\"1A+\u0001Q\u0001\n\u001d3A\u0001L\u0010\u0001+\"Aqm\u0002B\u0001B\u0003%\u0001\u000e\u0003\u0005o\u000f\t\u0005\t\u0015!\u0003p\u0011!QxA!A!\u0002\u0013Y\bBCA\u0002\u000f\t\u0005\t\u0015!\u0003\u0002\u0006!1Ag\u0002C\u0001\u0003\u0017A\u0011\"a\u0006\b\u0005\u0004%Y!!\u0007\t\u0011\u0005\u0015r\u0001)A\u0005\u00037A\u0011\"a\n\b\u0001\u0004%I!!\u000b\t\u0013\u0005Er\u00011A\u0005\n\u0005M\u0002\u0002CA \u000f\u0001\u0006K!a\u000b\t\u000f\u0005%s\u0001\"\u0011\u0002L!9\u0011qK\u0004\u0005B\u0005e\u0003bBA:\u000f\u0011\u0005\u0013Q\u000f\u0005\b\u0003{:A\u0011AA@\u0011\u001d\t\u0019i\u0002C\u0001\u0003\u000bCq!!#\b\t\u0003\tY\tC\u0004\u0002\u0010\u001e!\t!!%\t\u000f\u0005-v\u0001\"\u0001\u0002.\"9\u0011\u0011X\u0004\u0005\u0002\u0005m\u0006bBAd\u000f\u0011\u0005\u0011\u0011\u001a\u0005\b\u0003+<A\u0011AAl\u0011\u001d\t)o\u0002C\u0005\u0003O\f1#T=T#2\u001bu.\\7b]\u0012D\u0015M\u001c3mKJT!\u0001I\u0011\u0002\u000b5L8/\u001d7\u000b\u0005\t\u001a\u0013AB:feZ,'O\u0003\u0002%K\u000511._;vE&T!AJ\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0013aA8sO\u000e\u0001\u0001CA\u0016\u0002\u001b\u0005y\"aE'z'Fc5i\\7nC:$\u0007*\u00198eY\u0016\u00148CA\u0001/!\ty#'D\u00011\u0015\u0005\t\u0014!B:dC2\f\u0017BA\u001a1\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012AK\u0001\u000eG>tg.\u00133D_VtG/\u001a:\u0016\u0003a\u0002\"!\u000f\"\u000e\u0003iR!a\u000f\u001f\u0002\r\u0005$x.\\5d\u0015\tid(\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u0010!\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u0003\u0006!!.\u0019<b\u0013\t\u0019%HA\u0007Bi>l\u0017nY%oi\u0016<WM]\u0001\u000fG>tg.\u00133D_VtG/\u001a:!\u0003I\u0019wN\u001c8JIR{7+Z:t\u0011\u0006tG\r\\3\u0016\u0003\u001d\u0003B\u0001S%L\u001d6\tA(\u0003\u0002Ky\t\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\u0005=b\u0015BA'1\u0005\rIe\u000e\u001e\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#\u000e\nqa]3tg&|g.\u0003\u0002T!\ni1+Z:tS>t\u0007*\u00198eY\u0016\f1cY8o]&#Gk\\*fgND\u0015M\u001c3mK\u0002\u001a2a\u0002,d!\r9f\fY\u0007\u00021*\u0011\u0011LW\u0001\bG\"\fgN\\3m\u0015\tYF,A\u0003oKR$\u0018PC\u0001^\u0003\tIw.\u0003\u0002`1\nY2+[7qY\u0016\u001c\u0005.\u00198oK2LeNY8v]\u0012D\u0015M\u001c3mKJ\u0004\"aK1\n\u0005\t|\"AE'z'Fc5i\\7nC:$\u0007+Y2lKR\u0004\"\u0001Z3\u000e\u0003\rJ!AZ\u0012\u0003\u000f1{wmZ5oO\u0006Q1/\u001a:wKJ\fE\r\u001a:\u0011\u0005%dW\"\u00016\u000b\u0005-\u0004\u0015a\u00018fi&\u0011QN\u001b\u0002\f\u0013:,G/\u00113ee\u0016\u001c8/A\u0007d_:tWm\u0019;j_:,&\u000f\u001c\t\u0003a^t!!];\u0011\u0005I\u0004T\"A:\u000b\u0005QL\u0013A\u0002\u001fs_>$h(\u0003\u0002wa\u00051\u0001K]3eK\u001aL!\u0001_=\u0003\rM#(/\u001b8h\u0015\t1\b'\u0001\u0002cKB\u0011Ap`\u0007\u0002{*\u0011apI\u0001\bg\u0016\u0014h/[2f\u0013\r\t\t! \u0002\u000f\u0005\u0006\u001c7.\u001a8e'\u0016\u0014h/[2f\u0003!)\u00070Z2Q_>d\u0007c\u0001%\u0002\b%\u0019\u0011\u0011\u0002\u001f\u0003%QC'/Z1e!>|G.\u0012=fGV$xN\u001d\u000b\u000b\u0003\u001b\ty!!\u0005\u0002\u0014\u0005U\u0001CA\u0016\b\u0011\u00159G\u00021\u0001i\u0011\u0015qG\u00021\u0001p\u0011\u0015QH\u00021\u0001|\u0011\u001d\t\u0019\u0001\u0004a\u0001\u0003\u000b\t!!Z2\u0016\u0005\u0005m\u0001\u0003BA\u000f\u0003Ci!!a\b\u000b\u0005u\u0002\u0014\u0002BA\u0012\u0003?\u0011\u0001$\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;Fq\u0016\u001cW\u000f^8s\u0003\r)7\rI\u0001\u0007G2|7/\u001a3\u0016\u0005\u0005-\u0002cA\u0018\u0002.%\u0019\u0011q\u0006\u0019\u0003\u000f\t{w\u000e\\3b]\u0006Q1\r\\8tK\u0012|F%Z9\u0015\t\u0005U\u00121\b\t\u0004_\u0005]\u0012bAA\u001da\t!QK\\5u\u0011%\ti\u0004EA\u0001\u0002\u0004\tY#A\u0002yIE\nqa\u00197pg\u0016$\u0007\u0005K\u0002\u0012\u0003\u0007\u00022aLA#\u0013\r\t9\u0005\r\u0002\tm>d\u0017\r^5mK\u0006y1\r[1o]\u0016d\u0017J\\1di&4X\r\u0006\u0003\u00026\u00055\u0003bBA(%\u0001\u0007\u0011\u0011K\u0001\u0004GRD\bcA,\u0002T%\u0019\u0011Q\u000b-\u0003+\rC\u0017M\u001c8fY\"\u000bg\u000e\u001a7fe\u000e{g\u000e^3yi\u0006yQ\r_2faRLwN\\\"bk\u001eDG\u000f\u0006\u0004\u00026\u0005m\u0013Q\f\u0005\b\u0003\u001f\u001a\u0002\u0019AA)\u0011\u001d\tyf\u0005a\u0001\u0003C\nQaY1vg\u0016\u0004B!a\u0019\u0002n9!\u0011QMA5\u001d\r\u0011\u0018qM\u0005\u0002c%\u0019\u00111\u000e\u0019\u0002\u000fA\f7m[1hK&!\u0011qNA9\u0005%!\u0006N]8xC\ndWMC\u0002\u0002lA\nAb\u00195b]:,GNU3bIB\"b!!\u000e\u0002x\u0005e\u0004bBA()\u0001\u0007\u0011\u0011\u000b\u0005\u0007\u0003w\"\u0002\u0019\u00011\u0002\rA\f7m[3u\u0003M)gn];sKN+7o]5p]>\u0003XM\\3e)\u0011\t)$!!\t\u000f\u0005=S\u00031\u0001\u0002R\u0005Yq\u000e]3o'\u0016\u001c8/[8o)\rq\u0015q\u0011\u0005\b\u0003\u001f2\u0002\u0019AA)\u00031\u0019Gn\\:f'\u0016\u001c8/[8o)\u0011\t)$!$\t\u000f\u0005=s\u00031\u0001\u0002R\u0005Q\u0001.\u00198eY\u0016\u0004\u0016N\\4\u0015\r\u0005M\u0015qTAQ!\u0019\t\u0019'!&\u0002\u001a&!\u0011qSA9\u0005\r\u0019V-\u001d\t\u0004W\u0005m\u0015bAAO?\tYQ*_*R\u0019B\u000b7m[3u\u0011\u001d\ty\u0005\u0007a\u0001\u0003#Bq!a)\u0019\u0001\u0004\t)+A\u0002qW\u001e\u00042aKAT\u0013\r\tIk\b\u0002\u0013\u001bf\u001c\u0016\u000bT\"p[BKgn\u001a)bG.,G/\u0001\u0007iC:$G.Z%oSR$%\r\u0006\u0004\u0002\u0014\u0006=\u0016\u0011\u0017\u0005\b\u0003\u001fJ\u0002\u0019AA)\u0011\u001d\t\u0019+\u0007a\u0001\u0003g\u00032aKA[\u0013\r\t9l\b\u0002\u0015\u001bf\u001c\u0016\u000bT\"p[&s\u0017\u000e\u001e#c!\u0006\u001c7.\u001a;\u0002\u0015!\fg\u000e\u001a7f#VLG\u000f\u0006\u0004\u0002\u0014\u0006u\u0016q\u0018\u0005\b\u0003\u001fR\u0002\u0019AA)\u0011\u001d\t\u0019K\u0007a\u0001\u0003\u0003\u00042aKAb\u0013\r\t)m\b\u0002\u0013\u001bf\u001c\u0016\u000bT\"p[F+\u0018\u000e\u001e)bG.,G/A\u0006iC:$G.Z)vKJLHCBAJ\u0003\u0017\fi\rC\u0004\u0002Pm\u0001\r!!\u0015\t\u000f\u0005\r6\u00041\u0001\u0002PB\u00191&!5\n\u0007\u0005MwDA\nNsN\u000bFjQ8n#V,'/\u001f)bG.,G/\u0001\tfq\u0016\u001cW\u000f^3Ti\u0006$X-\\3oiR1\u0011\u0011\\Ap\u0003C\u00042aKAn\u0013\r\tin\b\u0002\u0011\u001bf\u001c\u0016\u000bT)vKJL(+Z:vYRDq!a\u0014\u001d\u0001\u0004\t\t\u0006\u0003\u0004\u0002dr\u0001\ra\\\u0001\u0004gFd\u0017A\u00052f\u000bb,7-\u001e;f'R\fG/Z7f]R$b!!7\u0002j\u0006-\bbBA(;\u0001\u0007\u0011\u0011\u000b\u0005\u0007\u0003Gl\u0002\u0019A8")
public class MySQLCommandHandler
extends SimpleChannelInboundHandler<MySQLCommandPacket>
implements Logging {
    private final InetAddress serverAddr;
    private final String connectionUrl;
    private final BackendService be;
    private final ExecutionContextExecutor ec;
    private volatile boolean closed;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    public static ConcurrentHashMap<Object, SessionHandle> connIdToSessHandle() {
        return MySQLCommandHandler$.MODULE$.connIdToSessHandle();
    }

    public static AtomicInteger connIdCounter() {
        return MySQLCommandHandler$.MODULE$.connIdCounter();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private ExecutionContextExecutor ec() {
        return this.ec;
    }

    private boolean closed() {
        return this.closed;
    }

    private void closed_$eq(boolean x$1) {
        this.closed = x$1;
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.closeSession(ctx);
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        Integer connectionId = (Integer)ctx.channel().attr(MySQLCtxAttrKey$.MODULE$.CONNECTION_ID()).get();
        MySQLErrPacket errPacket = MySQLErrPacket$.MODULE$.apply(cause);
        this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Connection: ").append(connectionId).append(", ").append(errPacket).toString());
        if (ctx.channel().isActive()) {
            ctx.writeAndFlush((Object)errPacket);
            return;
        }
        this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Ignore error packet for inactivated connection: ").append(connectionId).toString());
    }

    public void channelRead0(ChannelHandlerContext ctx, MySQLCommandPacket packet) {
        Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            this.ensureSessionOpened(ctx);
            MySQLCommandPacket mySQLCommandPacket = packet;
            if (mySQLCommandPacket instanceof MySQLComPingPacket) {
                MySQLComPingPacket mySQLComPingPacket = (MySQLComPingPacket)mySQLCommandPacket;
                return this.handlePing(ctx, mySQLComPingPacket);
            }
            if (mySQLCommandPacket instanceof MySQLComInitDbPacket) {
                MySQLComInitDbPacket mySQLComInitDbPacket = (MySQLComInitDbPacket)mySQLCommandPacket;
                return this.handleInitDb(ctx, mySQLComInitDbPacket);
            }
            if (mySQLCommandPacket instanceof MySQLComQuitPacket) {
                MySQLComQuitPacket mySQLComQuitPacket = (MySQLComQuitPacket)mySQLCommandPacket;
                return this.handleQuit(ctx, mySQLComQuitPacket);
            }
            if (mySQLCommandPacket instanceof MySQLComQueryPacket) {
                MySQLComQueryPacket mySQLComQueryPacket = (MySQLComQueryPacket)mySQLCommandPacket;
                return this.handleQuery(ctx, mySQLComQueryPacket);
            }
            throw new UnsupportedOperationException(mySQLCommandPacket.getClass().getSimpleName());
        }, (ExecutionContext)this.ec()).onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Seq responsePackets = (Seq)success.value();
                Channel channel = ctx.channel();
                responsePackets.foreach((Function1 & Serializable & scala.Serializable)x$1 -> channel.write(x$1));
                return ctx.channel().flush();
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable cause = failure.exception();
                this.exceptionCaught(ctx, cause);
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)try_);
        }, (ExecutionContext)this.ec());
    }

    public void ensureSessionOpened(ChannelHandlerContext ctx) {
        if (ctx.channel().attr(MySQLCtxAttrKey$.MODULE$.SESSION_HANDLE()).get() == null) {
            MySQLCommandHandler mySQLCommandHandler = this;
            synchronized (mySQLCommandHandler) {
                BoxedUnit boxedUnit;
                if (ctx.channel().attr(MySQLCtxAttrKey$.MODULE$.SESSION_HANDLE()).get() == null) {
                    SessionHandle sessionHandle = this.openSession(ctx);
                    ctx.channel().attr(MySQLCtxAttrKey$.MODULE$.SESSION_HANDLE()).set((Object)sessionHandle);
                    Integer connectionId = (Integer)ctx.channel().attr(MySQLCtxAttrKey$.MODULE$.CONNECTION_ID()).get();
                    boxedUnit = MySQLCommandHandler$.MODULE$.connIdToSessHandle().put(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(connectionId)), sessionHandle);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            return;
        }
    }

    public synchronized SessionHandle openSession(ChannelHandlerContext ctx) {
        SessionHandle sessionHandle;
        try {
            SessionHandle sessionHandle2;
            Map map;
            String user = (String)ctx.channel().attr(MySQLCtxAttrKey$.MODULE$.USER()).get();
            String remoteIp = (String)ctx.channel().attr(MySQLCtxAttrKey$.MODULE$.REMOTE_IP()).get();
            Option option = Option$.MODULE$.apply(ctx.channel().attr(MySQLCtxAttrKey$.MODULE$.DATABASE()).get());
            if (option instanceof Some) {
                Some some = (Some)option;
                String db = (String)some.value();
                map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"use:database"), (Object)db)}));
            } else if (None$.MODULE$.equals(option)) {
                map = Predef$.MODULE$.Map().empty();
            } else {
                throw new MatchError((Object)option);
            }
            Map sessionConf = map;
            TProtocolVersion proto = TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V1;
            sessionHandle = sessionHandle2 = this.be.openSession(proto, user, "", remoteIp, ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.client.ipAddress"), (Object)remoteIp), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.server.ipAddress"), (Object)this.serverAddr.getHostAddress())}))).$plus$plus((GenTraversableOnce)sessionConf).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.session.connection.url"), (Object)this.connectionUrl), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.session.real.user"), (Object)user)}))));
        }
        catch (Exception rethrow) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Error opening session: ").append(rethrow.getMessage()).toString());
            throw rethrow;
        }
        return sessionHandle;
    }

    public synchronized void closeSession(ChannelHandlerContext ctx) {
        if (!this.closed()) {
            SessionHandle handle = (SessionHandle)ctx.channel().attr(MySQLCtxAttrKey$.MODULE$.SESSION_HANDLE()).get();
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Received request of closing ").append(handle).toString());
            try {
                try {
                    this.be.closeSession(handle);
                }
                catch (Exception rethrow) {
                    this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Error closing session: ").append(rethrow.getMessage()).toString());
                    throw rethrow;
                }
            }
            finally {
                Integer connectionId = (Integer)ctx.channel().attr(MySQLCtxAttrKey$.MODULE$.CONNECTION_ID()).getAndSet(null);
                ctx.channel().attr(MySQLCtxAttrKey$.MODULE$.SESSION_HANDLE()).set(null);
                MySQLCommandHandler$.MODULE$.connIdToSessHandle().remove(connectionId);
            }
            this.closed_$eq(true);
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Finished closing ").append(handle).toString());
            return;
        }
    }

    public Seq<MySQLPacket> handlePing(ChannelHandlerContext ctx, MySQLComPingPacket pkg) {
        MySQLOKPacket mySQLOKPacket = new MySQLOKPacket(1, MySQLOKPacket$.MODULE$.apply$default$2(), MySQLOKPacket$.MODULE$.apply$default$3());
        return Nil$.MODULE$.$colon$colon((Object)mySQLOKPacket);
    }

    public Seq<MySQLPacket> handleInitDb(ChannelHandlerContext ctx, MySQLComInitDbPacket pkg) {
        this.beExecuteStatement(ctx, new StringBuilder(4).append("use ").append(pkg.database()).toString());
        MySQLOKPacket mySQLOKPacket = new MySQLOKPacket(1, MySQLOKPacket$.MODULE$.apply$default$2(), MySQLOKPacket$.MODULE$.apply$default$3());
        return Nil$.MODULE$.$colon$colon((Object)mySQLOKPacket);
    }

    public Seq<MySQLPacket> handleQuit(ChannelHandlerContext ctx, MySQLComQuitPacket pkg) {
        this.closeSession(ctx);
        MySQLOKPacket mySQLOKPacket = new MySQLOKPacket(1, MySQLOKPacket$.MODULE$.apply$default$2(), MySQLOKPacket$.MODULE$.apply$default$3());
        return Nil$.MODULE$.$colon$colon((Object)mySQLOKPacket);
    }

    public Seq<MySQLPacket> handleQuery(ChannelHandlerContext ctx, MySQLComQueryPacket pkg) {
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Receive query: ").append(pkg.sql()).toString());
        return this.executeStatement(ctx, pkg.sql()).toPackets();
    }

    public MySQLQueryResult executeStatement(ChannelHandlerContext ctx, String sql) {
        String newSQL = MySQLDialectHelper$.MODULE$.convertQuery(sql);
        String string = sql;
        String string2 = newSQL;
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Converted to ").append(newSQL).toString());
        }
        if (MySQLDialectHelper$.MODULE$.shouldExecuteLocal(newSQL)) {
            return MySQLDialectHelper$.MODULE$.localExecuteStatement(ctx, newSQL);
        }
        return this.beExecuteStatement(ctx, newSQL);
    }

    private MySQLQueryResult beExecuteStatement(ChannelHandlerContext ctx, String sql) {
        MySQLThriftQueryResult mySQLThriftQueryResult;
        try {
            SessionHandle ssHandle = (SessionHandle)ctx.channel().attr(MySQLCtxAttrKey$.MODULE$.SESSION_HANDLE()).get();
            OperationHandle opHandle = this.be.executeStatement(ssHandle, sql, Predef$.MODULE$.Map().empty(), false, 0L);
            OperationStatus opStatus = this.be.getOperationStatus(opHandle, this.be.getOperationStatus$default$2());
            Enumeration.Value value = opStatus.state();
            Enumeration.Value value2 = OperationState$.MODULE$.FINISHED();
            if (value == null ? value2 != null : !value.equals(value2)) {
                throw (Throwable)opStatus.exception().getOrElse((Function0 & Serializable & scala.Serializable)() -> KyuubiSQLException$.MODULE$.apply(new StringBuilder(21).append("Error operator state ").append(opStatus.state()).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4()));
            }
            TGetResultSetMetadataResp resultSetMetadata = this.be.getResultSetMetadata(opHandle);
            TFetchResultsResp fetchResultResp = this.be.fetchResults(opHandle, FetchOrientation$.MODULE$.FETCH_NEXT(), Integer.MAX_VALUE, false);
            TRowSet rowSet = fetchResultResp.getResults();
            mySQLThriftQueryResult = MySQLQueryResult$.MODULE$.apply(resultSetMetadata.getSchema(), rowSet);
        }
        catch (Exception rethrow) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Error executing statement: ", rethrow);
            throw rethrow;
        }
        return mySQLThriftQueryResult;
    }

    public MySQLCommandHandler(InetAddress serverAddr, String connectionUrl, BackendService be, ThreadPoolExecutor execPool) {
        this.serverAddr = serverAddr;
        this.connectionUrl = connectionUrl;
        this.be = be;
        Logging.$init$((Logging)this);
        this.ec = ExecutionContext$.MODULE$.fromExecutor((Executor)execPool);
        this.closed = false;
    }
}

