/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.trino;

import com.google.common.base.Verify;
import io.trino.client.ClientSession;
import io.trino.client.ClientTypeSignature;
import io.trino.client.Column;
import io.trino.client.QueryStatusInfo;
import io.trino.client.StatementClient;
import io.trino.client.StatementClientFactory;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import okhttp3.OkHttpClient;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.trino.TrinoConf$;
import org.apache.kyuubi.engine.trino.TrinoContext;
import org.apache.kyuubi.engine.trino.TrinoStatement$;
import org.apache.kyuubi.engine.trino.TrinoStatusPrinter$;
import org.apache.kyuubi.operation.log.OperationLog;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.MapLike;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\r\u001b\u0001\u0015B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\tk\u0001\u0011\t\u0011)A\u0005m!AA\b\u0001B\u0001B\u0003%Q\b\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003J\u0011\u0015!\u0006\u0001\"\u0001V\u0011\u001dY\u0006A1A\u0005\nqCaa\u001c\u0001!\u0002\u0013i\u0006\u0002C\u000e\u0001\u0011\u000b\u0007I\u0011\u00029\t\u0011Q\u0004\u0001R1A\u0005\nUD\u0001\"\u001f\u0001\t\u0006\u0004%IA\u001f\u0005\t}\u0002A)\u0019!C\u0005u\"Aq\u0010\u0001b\u0001\n\u0007\t\t\u0001\u0003\u0005\u0002\u0010\u0001\u0001\u000b\u0011BA\u0002\u0011\u0019\t\t\u0002\u0001C\u0001a\"9\u00111\u0003\u0001\u0005\u0002\u0005U\u0001bBA\f\u0001\u0011\u0005\u0011Q\u0003\u0005\u0007\u00033\u0001A\u0011\u0001/\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e!9\u0011Q\u0006\u0001\u0005\u0002\u0005=raBA\u001c5!\u0005\u0011\u0011\b\u0004\u00073iA\t!a\u000f\t\rQ+B\u0011AA\u001f\u0011\u001d\ty$\u0006C\u0001\u0003\u0003B\u0011\"a\u0013\u0016#\u0003%\t!!\u0014\u0003\u001dQ\u0013\u0018N\\8Ti\u0006$X-\\3oi*\u00111\u0004H\u0001\u0006iJLgn\u001c\u0006\u0003;y\ta!\u001a8hS:,'BA\u0010!\u0003\u0019Y\u00170^;cS*\u0011\u0011EI\u0001\u0007CB\f7\r[3\u000b\u0003\r\n1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0014-!\t9#&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005\u0019\te.\u001f*fMB\u0011QFL\u0007\u0002=%\u0011qF\b\u0002\b\u0019><w-\u001b8h\u00031!(/\u001b8p\u0007>tG/\u001a=u!\t\u00114'D\u0001\u001b\u0013\t!$D\u0001\u0007Ue&twnQ8oi\u0016DH/\u0001\u0006lsV,(-[\"p]\u001a\u0004\"a\u000e\u001e\u000e\u0003aR!!\u000f\u0010\u0002\r\r|gNZ5h\u0013\tY\u0004H\u0001\u0006LsV,(-[\"p]\u001a\f1a]9m!\tqTI\u0004\u0002@\u0007B\u0011\u0001\tK\u0007\u0002\u0003*\u0011!\tJ\u0001\u0007yI|w\u000e\u001e \n\u0005\u0011C\u0013A\u0002)sK\u0012,g-\u0003\u0002G\u000f\n11\u000b\u001e:j]\u001eT!\u0001\u0012\u0015\u0002\u0019=\u0004XM]1uS>tGj\\4\u0011\u0007\u001dRE*\u0003\u0002LQ\t1q\n\u001d;j_:\u0004\"!\u0014*\u000e\u00039S!a\u0014)\u0002\u00071|wM\u0003\u0002R=\u0005Iq\u000e]3sCRLwN\\\u0005\u0003':\u0013Ab\u00149fe\u0006$\u0018n\u001c8M_\u001e\fa\u0001P5oSRtD#\u0002,X1fS\u0006C\u0001\u001a\u0001\u0011\u0015\u0001T\u00011\u00012\u0011\u0015)T\u00011\u00017\u0011\u0015aT\u00011\u0001>\u0011\u0015AU\u00011\u0001J\u00035!WMZ1vYR\u001c6\r[3nCV\tQ\fE\u0002_G\u001at!aX1\u000f\u0005\u0001\u0003\u0017\"A\u0015\n\u0005\tD\u0013a\u00029bG.\fw-Z\u0005\u0003I\u0016\u0014A\u0001T5ti*\u0011!\r\u000b\t\u0003O6l\u0011\u0001\u001b\u0006\u0003S*\faa\u00197jK:$(BA\u000el\u0015\u0005a\u0017AA5p\u0013\tq\u0007N\u0001\u0004D_2,XN\\\u0001\u000fI\u00164\u0017-\u001e7u'\u000eDW-\\1!+\u0005\t\bCA4s\u0013\t\u0019\bNA\bTi\u0006$X-\\3oi\u000ec\u0017.\u001a8u\u0003Y!\u0017\r^1Qe>\u001cWm]:j]\u001e\u0004vn\u001c7TSj,W#\u0001<\u0011\u0005\u001d:\u0018B\u0001=)\u0005\rIe\u000e^\u0001\fg\"|w\u000f\u0015:pG\u0016\u001c8/F\u0001|!\t9C0\u0003\u0002~Q\t9!i\\8mK\u0006t\u0017!C:i_^$UMY;h\u0003\t)7-\u0006\u0002\u0002\u0004A!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\n!\n!bY8oGV\u0014(/\u001a8u\u0013\u0011\ti!a\u0002\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018aA3dA\u0005qq-\u001a;Ue&twn\u00117jK:$\u0018!E4fi\u000e+(O]3oi\u000e\u000bG/\u00197pOV\tQ(\u0001\nhKR\u001cUO\u001d:f]R$\u0015\r^1cCN,\u0017AC4fi\u000e{G.^7og\u00069Q\r_3dkR,GCAA\u0010!\u0015q\u0016\u0011EA\u0013\u0013\r\t\u0019#\u001a\u0002\t\u0013R,'/\u0019;peB!alYA\u0014!\r9\u0013\u0011F\u0005\u0004\u0003WA#aA!os\u0006\u0011R\u000f\u001d3bi\u0016$&/\u001b8p\u0007>tG/\u001a=u)\t\t\t\u0004E\u0002(\u0003gI1!!\u000e)\u0005\u0011)f.\u001b;\u0002\u001dQ\u0013\u0018N\\8Ti\u0006$X-\\3oiB\u0011!'F\n\u0003+\u0019\"\"!!\u000f\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013Y\u000b\u0019%!\u0012\u0002H\u0005%\u0003\"\u0002\u0019\u0018\u0001\u0004\t\u0004\"B\u001b\u0018\u0001\u00041\u0004\"\u0002\u001f\u0018\u0001\u0004i\u0004b\u0002%\u0018!\u0003\u0005\r!S\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011q\n\u0016\u0004\u0013\u0006E3FAA*!\u0011\t)&a\u0018\u000e\u0005\u0005]#\u0002BA-\u00037\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005u\u0003&\u0001\u0006b]:|G/\u0019;j_:LA!!\u0019\u0002X\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class TrinoStatement
implements Logging {
    private StatementClient trino;
    private int dataProcessingPoolSize;
    private boolean showProcess;
    private boolean showDebug;
    private final TrinoContext trinoContext;
    private final KyuubiConf kyuubiConf;
    private String sql;
    private final Option<OperationLog> operationLog;
    private final List<Column> defaultSchema;
    private final ExecutionContext ec;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    private volatile byte bitmap$0;

    public static Option<OperationLog> apply$default$4() {
        return TrinoStatement$.MODULE$.apply$default$4();
    }

    public static TrinoStatement apply(TrinoContext trinoContext, KyuubiConf kyuubiConf, String string, Option<OperationLog> option) {
        return TrinoStatement$.MODULE$.apply(trinoContext, kyuubiConf, string, option);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private List<Column> defaultSchema() {
        return this.defaultSchema;
    }

    private StatementClient trino$lzycompute() {
        TrinoStatement trinoStatement = this;
        synchronized (trinoStatement) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.trino = StatementClientFactory.newStatementClient((OkHttpClient)this.trinoContext.httpClient(), (ClientSession)this.trinoContext.clientSession().get(), (String)this.sql);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.sql = null;
        return this.trino;
    }

    private StatementClient trino() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.trino$lzycompute();
        }
        return this.trino;
    }

    private int dataProcessingPoolSize$lzycompute() {
        TrinoStatement trinoStatement = this;
        synchronized (trinoStatement) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.dataProcessingPoolSize = BoxesRunTime.unboxToInt((Object)this.kyuubiConf.get(TrinoConf$.MODULE$.DATA_PROCESSING_POOL_SIZE()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.dataProcessingPoolSize;
    }

    private int dataProcessingPoolSize() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.dataProcessingPoolSize$lzycompute();
        }
        return this.dataProcessingPoolSize;
    }

    private boolean showProcess$lzycompute() {
        TrinoStatement trinoStatement = this;
        synchronized (trinoStatement) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.showProcess = BoxesRunTime.unboxToBoolean((Object)this.kyuubiConf.get(KyuubiConf$.MODULE$.ENGINE_TRINO_SHOW_PROGRESS()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.showProcess;
    }

    private boolean showProcess() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.showProcess$lzycompute();
        }
        return this.showProcess;
    }

    private boolean showDebug$lzycompute() {
        TrinoStatement trinoStatement = this;
        synchronized (trinoStatement) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.showDebug = BoxesRunTime.unboxToBoolean((Object)this.kyuubiConf.get(KyuubiConf$.MODULE$.ENGINE_TRINO_SHOW_PROGRESS_DEBUG()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.showDebug;
    }

    private boolean showDebug() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.showDebug$lzycompute();
        }
        return this.showDebug;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public StatementClient getTrinoClient() {
        return this.trino();
    }

    public String getCurrentCatalog() {
        return this.trinoContext.clientSession().get().getCatalog();
    }

    public String getCurrentDatabase() {
        return this.trinoContext.clientSession().get().getSchema();
    }

    public List<Column> getColumns() {
        while (this.trino().isRunning()) {
            QueryStatusInfo results = this.trino().currentStatusInfo();
            java.util.List columns = results.getColumns();
            if (columns != null) {
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Execute with Trino query id: ").append(results.getId()).toString());
                if (columns.isEmpty()) {
                    return this.defaultSchema();
                }
                return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(columns).asScala()).toList();
            }
            this.trino().advance();
        }
        Verify.verify((boolean)this.trino().isFinished());
        QueryStatusInfo finalStatus = this.trino().finalStatusInfo();
        if (finalStatus.getError() == null) {
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(24).append("Query has no columns (#").append(finalStatus.getId()).append(")").toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(18).append("Query failed (#").append(finalStatus.getId()).append("): ").append(finalStatus.getError().getMessage()).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
    }

    public Iterator<List<Object>> execute() {
        return package$.MODULE$.Iterator().continually((Function0 & Serializable & scala.Serializable)() -> this.getData$1()).takeWhile((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2._1$mcZ$sp())).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> (List)x$3._2());
    }

    public void updateTrinoContext() {
        ClientSession session = this.trinoContext.clientSession().get();
        ClientSession.Builder builder = ClientSession.builder((ClientSession)session);
        if (this.trino().getSetCatalog().isPresent() || this.trino().getSetSchema().isPresent()) {
            builder = builder.withCatalog(this.trino().getSetCatalog().orElse(session.getCatalog())).withSchema(this.trino().getSetSchema().orElse(session.getSchema()));
        }
        if (this.trino().getSetPath().isPresent()) {
            builder = builder.withPath((String)this.trino().getSetPath().get());
        }
        if (!this.trino().getSetSessionProperties().isEmpty() || !this.trino().getResetSessionProperties().isEmpty()) {
            scala.collection.mutable.Map properties = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(session.getProperties()).asScala()).clone();
            properties.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.trino().getSetSessionProperties()).asScala());
            properties.$minus$minus$eq((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.trino().getResetSessionProperties()).asScala());
            builder = builder.withProperties((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(properties).asJava());
        }
        this.trinoContext.clientSession().set(builder.build());
    }

    private final Tuple2 getData$1() {
        QueryStatusInfo finalStatus;
        while (this.trino().isRunning()) {
            Iterable data = this.trino().currentData().getData();
            this.trino().advance();
            if (data == null) continue;
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(data).asScala()).toList().map((Function1 & Serializable & scala.Serializable)x$1 -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(x$1).asScala()).toList(), List$.MODULE$.canBuildFrom()));
        }
        Verify.verify((boolean)this.trino().isFinished());
        if (this.operationLog.isDefined() && this.showProcess()) {
            TrinoStatusPrinter$.MODULE$.printFinalInfo(this.trino(), (OperationLog)this.operationLog.get(), this.showDebug());
        }
        if ((finalStatus = this.trino().finalStatusInfo()).getError() != null) {
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(15).append("Query ").append(finalStatus.getId()).append(" failed: ").append(finalStatus.getError().getMessage()).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        this.updateTrinoContext();
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)Nil$.MODULE$);
    }

    public TrinoStatement(TrinoContext trinoContext, KyuubiConf kyuubiConf, String sql, Option<OperationLog> operationLog) {
        this.trinoContext = trinoContext;
        this.kyuubiConf = kyuubiConf;
        this.sql = sql;
        this.operationLog = operationLog;
        Logging.$init$((Logging)this);
        this.defaultSchema = new .colon.colon((Object)new Column("Result", "VARCHAR", new ClientTypeSignature("VARCHAR")), (List)Nil$.MODULE$);
        this.ec = ExecutionContext$.MODULE$.fromExecutor((Executor)Executors.newFixedThreadPool(this.dataProcessingPoolSize()));
    }
}

